/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.multicore.pscd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import kr.ac.kaist.itcknow.bigml.algo.multicore.sgd.LRSGD;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class LRTrainPSGD3
extends LRSGD {
    public Slave[] slaves;
    public Thread[] threads;
    public int num_threads;
    public int num_processes;
    public CountDownLatch doneSignal;
    public static String opt_num_procs = "num_procs";
    public static String opt_num_threads = "num_threads";

    public static Options InitOptions() {
        LRSGD.InitOptions();
        options.addOption("np", opt_num_procs, true, "Number of Processes");
        options.addOption("nt", opt_num_threads, true, "Number of Threads");
        return options;
    }

    public LRTrainPSGD3(CommandLine cli) {
        super(cli);
        this.num_threads = cli.hasOption(opt_num_threads) ? Integer.parseInt(cli.getOptionValue(opt_num_threads)) : 1;
        this.num_processes = cli.hasOption(opt_num_procs) ? Integer.parseInt(cli.getOptionValue(opt_num_procs)) : 1;
        this.threads = new Thread[this.num_threads];
        this.slaves = new Slave[this.num_threads];
        this.doneSignal = new CountDownLatch(this.num_threads);
        for (int p = 0; p < this.num_threads; ++p) {
            this.slaves[p] = new Slave(this, p);
            this.threads[p] = new Thread(this.slaves[p]);
        }
    }

    public void startParallel() {
        for (int p = 0; p < this.num_processes; ++p) {
            this.threads[p].start();
        }
    }

    public static void main(String[] args) throws Exception {
        args = "--x testPSGD3 --f data/training_D_100_N_10000.txt --i 100 --np 2 --nt 2".split(" ");
        PosixParser parser = new PosixParser();
        LRTrainPSGD3.InitOptions();
        CommandLine cli = parser.parse(options, args);
        LRTrainPSGD3 log_reg = new LRTrainPSGD3(cli);
        log_reg.startParallel();
        log_reg.doneSignal.await();
    }

    public static class Slave
    implements Runnable {
        public int process_id;
        public LRTrainPSGD3 master;

        public Slave(LRTrainPSGD3 master, int process_id) {
            this.master = master;
            this.process_id = process_id;
        }

        @Override
        public void run() {
            try {
                String line;
                ProcessBuilder pb = new ProcessBuilder("java", "-cp", "target/PSCD-0.0.1-SNAPSHOT.jar;./lib/commons-cli-1.2.jar", "-Xmx1g", "kr.ac.kaist.itcknow.bigml.psgd.LRTrainPSGD2", String.format("--experiment_name=%s_psgd3", this.master.expt), String.format("--input_file=%s", this.master.input_file), String.format("--iterations=%d", this.master.iterations), String.format("--epsilon=%f", this.master.epsilon), String.format("--interval=%d", this.master.interval), String.format("--process_id=%d", this.process_id), String.format("--num_procs=%d", this.master.num_processes), String.format("--num_threads=%d", this.master.num_threads), String.format("--start_time=%d", this.master.start_time));
                pb.directory(new File(System.getProperty("user.dir")));
                pb.redirectErrorStream(true);
                Process p = pb.start();
                InputStream stdout = p.getInputStream();
                BufferedWriter bw = new BufferedWriter(new FileWriter(String.format("./log/%s_psgd3_%d.log", this.master.expt, this.process_id)));
                BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
                while ((line = br.readLine()) != null) {
                    bw.write(line);
                    bw.newLine();
                }
                br.close();
                bw.close();
                p.waitFor();
                this.master.doneSignal.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.master.doneSignal.countDown();
            }
        }
    }
}

