/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.multicore;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import kr.ac.kaist.itcknow.bigml.algo.multicore.cd.LRCD;
import kr.ac.kaist.itcknow.bigml.algo.multicore.sgd.LRSGD;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.PosixParser;

public class MainClient {
    public static void main(String[] args) throws Exception {
        int iter;
        args = "--x test --f input/sample/training_D_100_N_10000.txt --tt input/sample/testing_D_100_N_10000.txt --i 10".split(" ");
        PosixParser parser = new PosixParser();
        LRSGD.InitOptions();
        CommandLine cli = parser.parse(LRSGD.options, args);
        LRCD lr = new LRCD(cli);
        lr.dataDeliminator = "\t";
        lr.readData();
        lr.init();
        System.out.println("Dim: " + lr.dim);
        System.out.println("Num labels: " + lr.num_label);
        System.out.println("Iterations: " + lr.iterations);
        System.out.println(String.format("Epsilon: %f", lr.epsilon));
        System.out.println();
        lr.isPrintParams = true;
        int nInstance = 0;
        for (int iter2 = 0; iter2 <= 10; ++iter2) {
            String line;
            LRCD.printParams(String.format("%s_sgd_p%d", lr.expt, lr.process_id), 0, lr.num_label, lr.dim, lr.etas, lr.label_index);
            BufferedReader br = new BufferedReader(new FileReader(lr.input_file));
            while ((line = br.readLine()) != null) {
                ++nInstance;
                int startIndex = 0;
                if (lr.isHadoopGeneratedData) {
                    startIndex = 1;
                }
                String[] tokens = line.toString().split(lr.dataDeliminator);
                int y = lr.getIndex(lr.label_index, tokens[startIndex]);
                double[] feature_vector = new double[lr.dim];
                for (int i = startIndex + 1; i < tokens.length; ++i) {
                    double x;
                    String[] toks = tokens[i].split(":");
                    int feature = lr.getIndex(lr.feature_index, toks[0]);
                    feature_vector[feature] = x = Double.parseDouble(toks[1]);
                }
                HashSet<String> dSet = new HashSet<String>();
                for (int d = 1; d <= lr.dim; ++d) {
                    dSet.add("" + d);
                }
                lr.trainOneInstance(dSet, new LRSGD.Data(y, feature_vector));
            }
            br.close();
            LRCD.printParams(String.format("%s_sgd_p%d", lr.expt, lr.process_id), iter2, lr.num_label, lr.dim, lr.etas, lr.label_index);
        }
        String expt = lr.expt;
        int iterations = lr.iterations;
        int interval = lr.interval;
        System.out.println("Iterations: " + iterations);
        System.out.println();
        for (iter = 0; iter <= iterations; iter += interval) {
            lr.readParams(String.format("params/%s_sgd_p0_%d.params", expt, iter));
            double ll = lr.calculateLikelihood();
            System.out.println(String.format("Process:%d\tThread:%d\tIterations:%d/%d\tLikelihood:%f", 0, 0, iter, iterations, ll));
        }
        System.out.println("Iterations: " + iterations);
        System.out.println();
        for (iter = 0; iter <= iterations; iter += interval) {
            lr.readParams(String.format("params/%s_sgd_p0_%d.params", expt, iter));
            LRSGD.Result res = lr.getAccuracy(new FileReader(lr.test_file));
            System.out.println(String.format("Process:%d\tThread:%d\tIterations:%d/%d\tAccuracy:%f", 0, 0, iter, iterations, res.accuracy));
        }
    }
}

