/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jmat.MatlabSyntax;
import org.jmat.data.Matrix;
import org.jmat.data.RandomMatrix;

public class GenSynData
extends Configured
implements Tool {
    public static Logger logger = Logger.getLogger(GenSynData.class);

    protected JobConf GenerateSyntheticDataJobConf(Path inPath, Path outPath, int D, int NperMapper, int NdividedM, int type) throws Exception {
        JobConf conf = new JobConf(this.getConf(), GenSynData.class);
        conf.setJobName("GenerateSyntheticData");
        conf.set("D", "" + D);
        conf.set("NperMapper", "" + NperMapper);
        conf.set("NdividedM", "" + NdividedM);
        conf.set("type", "" + type);
        logger.info((Object)"GenerateSyntheticData :: nreducers : ");
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(MyMapper.class);
        conf.setReducerClass(MyReducer.class);
        conf.setNumReduceTasks(1);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        return conf;
    }

    public int run(String[] args) throws Exception {
        int[] D_scale_mag;
        int[] N_scale_mag;
        double[] D_scale;
        double[] N_scale;
        if (args.length != 8) {
            System.exit(GenSynData.printUsage());
        }
        String hdfsPath = "hdfs://172.20.1.1:9000/user/dykang/";
        int N = 480000;
        int D = 18000;
        double S = 0.01;
        Path tempPath = new Path(args[0]);
        Path inPath = new Path(args[1]);
        Path outPath = new Path(args[2]);
        hdfsPath = args[3];
        int dsType = Integer.parseInt(args[4]);
        N = Integer.parseInt(args[5]);
        D = Integer.parseInt(args[6]);
        S = Double.parseDouble(args[7]);
        int nmappers = 100;
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        double[] N_scale_ds = null;
        double[] D_scale_ds = null;
        int[] N_scale_mag_ds = null;
        int[] D_scale_mag_ds = null;
        int scaleSize = 5;
        if (dsType == 1) {
            N_scale = new double[]{0.0625, 0.25, 1.0, 4.0, 16.0};
            D_scale = new double[]{0.0625, 0.25, 1.0, 4.0, 16.0};
            int[] nArray = new int[5];
            nArray[0] = -4;
            nArray[1] = -2;
            nArray[3] = 2;
            nArray[4] = 4;
            N_scale_mag = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = -4;
            nArray2[1] = -2;
            nArray2[3] = 2;
            nArray2[4] = 4;
            D_scale_mag = nArray2;
            N_scale_ds = N_scale;
            D_scale_ds = D_scale;
            N_scale_mag_ds = N_scale_mag;
            D_scale_mag_ds = D_scale_mag;
        } else if (dsType == 2) {
            N_scale = new double[]{0.00390625, 0.0625, 1.0, 16.0, 256.0};
            D_scale = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
            int[] nArray = new int[5];
            nArray[0] = -8;
            nArray[1] = -4;
            nArray[3] = 4;
            nArray[4] = 8;
            N_scale_mag = nArray;
            D_scale_mag = new int[5];
            N_scale_ds = N_scale;
            D_scale_ds = D_scale;
            N_scale_mag_ds = N_scale_mag;
            D_scale_mag_ds = D_scale_mag;
        } else if (dsType == 3) {
            N_scale = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
            D_scale = new double[]{0.00390625, 0.0625, 1.0, 16.0, 256.0};
            N_scale_mag = new int[5];
            int[] nArray = new int[5];
            nArray[0] = -8;
            nArray[1] = -4;
            nArray[3] = 4;
            nArray[4] = 8;
            D_scale_mag = nArray;
            N_scale_ds = N_scale;
            D_scale_ds = D_scale;
            N_scale_mag_ds = N_scale_mag;
            D_scale_mag_ds = D_scale_mag;
        } else {
            System.out.println("Wrong dataset type: " + dsType);
            System.exit(1);
        }
        int scale_index = 0;
        while (scale_index < scaleSize) {
            String inPath_exp = inPath.toString();
            String scaleFolder = dsType + "_" + scale_index;
            inPath_exp = String.valueOf(inPath_exp) + "/" + scaleFolder;
            System.out.println("Running.... ");
            System.out.println("nmappers = " + nmappers + " D = " + D + " N = " + N + " S = " + S + " N_SCALE = " + N_scale_ds[scale_index] + " D_SCALE = " + D_scale_ds[scale_index]);
            int D_scaled = (int)((double)D * D_scale_ds[scale_index]);
            String local_output = "./output/gensyn";
            FileUtil.fullyDelete((File)new File(String.valueOf(local_output) + "/*"));
            int d = 1;
            while (d <= nmappers) {
                String cfileName = String.format("%d.txt", d);
                Path cfilePath = new Path(String.valueOf(local_output) + "/" + cfileName);
                BufferedWriter br = new BufferedWriter(new FileWriter(new File(cfilePath.toString())));
                br.write(String.valueOf(d) + "\n");
                br.close();
                fs.copyFromLocalFile(cfilePath, tempPath);
                ++d;
            }
            RandomMatrix eta = MatlabSyntax.unifRnd(D_scaled, 1, -1.0, 1.0);
            String eta_output = "./output/gensyn/";
            String etafileName = String.format("eta_%d.txt", D_scaled);
            Path etafilePath = new Path(String.valueOf(eta_output) + "/" + etafileName);
            BufferedWriter br = new BufferedWriter(new FileWriter(new File(etafilePath.toString())));
            int i = 0;
            while (i < D_scaled) {
                br.write(String.valueOf(eta.get(i, 0)) + "\n");
                ++i;
            }
            br.close();
            fs.copyFromLocalFile(etafilePath, inPath);
            System.out.println("delete: " + hdfsPath + inPath_exp);
            fs.delete(new Path(String.valueOf(hdfsPath) + inPath_exp), true);
            JobClient.runJob((JobConf)this.GenerateSyntheticDataJobConf(new Path(tempPath.toString()), new Path(inPath_exp), D_scaled, (int)((double)N * N_scale_ds[scale_index] / (double)nmappers), N / nmappers, 2));
            String wholefilename = String.format("whole_D_%d_N_%d_S_%.2f_NS_%d_DS_%d.txt", D, N, S, N_scale_mag_ds[scale_index], D_scale_mag_ds[scale_index]);
            fs.delete(new Path(String.valueOf(hdfsPath) + outPath + dsType + "/" + wholefilename), true);
            fs.rename(new Path(String.valueOf(inPath_exp) + "/" + "part-00000"), new Path(String.valueOf(outPath.toString()) + "/" + dsType + "/" + wholefilename));
            System.out.println("Moving: " + inPath_exp + "/" + "part-00000" + " TO " + outPath.toString() + "/" + dsType + "/" + wholefilename);
            ++scale_index;
        }
        return 0;
    }

    private static int printUsage() {
        System.out.println("GenSynData <tempPath> <inPath> <outPath> <hdfsPath> <datasetType> <N> <D> <S>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"./log4j.properties");
        logger.info((Object)"GenerateSyntheticData running....");
        int result = ToolRunner.run((Configuration)new Configuration(), (Tool)new GenSynData(), (String[])args);
        System.exit(result);
    }

    public static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, Text> {
        int D;
        int N;
        int nmappers = 200;
        int NdividedM;
        int type = 0;

        public void configure(JobConf job) {
            this.D = Integer.parseInt(job.get("D"));
            this.N = Integer.parseInt(job.get("NperMapper"));
            this.NdividedM = Integer.parseInt(job.get("NdividedM"));
            this.type = Integer.parseInt(job.get("type"));
            logger.info((Object)"[GenerateSynthetiscData] MapStage configure(): nreducers = ");
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            double min = -1.0;
            double max = 1.0;
            Random r = new Random();
            if (this.type == 0) {
                this.N = (int)((double)this.N * 0.9);
            } else if (this.type == 1) {
                this.N = (int)((double)this.N * 0.1);
            } else if (this.type != 2) {
                System.out.println("type error");
                System.exit(1);
            }
            RandomMatrix eta = new RandomMatrix(this.D, 1);
            Path pt = new Path("hdfs://172.20.1.1:9000/user/dykang/input/ds/" + String.format("eta_%d.txt", this.D));
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(pt)));
            String line = "";
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                Double p = Double.parseDouble(line);
                eta.set(i++, 0, p);
            }
            int n = 1;
            while (n <= this.N) {
                line = "";
                RandomMatrix x = MatlabSyntax.unifRnd(this.D, 1, min, max);
                Matrix ex = MatlabSyntax.times(MatlabSyntax.t(eta), x);
                double prob = ex.get(0, 0);
                int label = 1;
                if ((prob += r.nextGaussian() * 0.1) > 0.0) {
                    ++label;
                }
                line = String.valueOf(line) + String.format("%d", label);
                int d = 1;
                while (d <= this.D) {
                    if (Math.random() < 0.1) {
                        line = String.valueOf(line) + String.format("\t%d:%f", d, x.get(d - 1, 0));
                    }
                    ++d;
                }
                int partitionIndex = (int)(Math.random() * (double)this.NdividedM);
                output.collect((Object)new IntWritable(0), (Object)new Text(line));
                ++n;
            }
        }
    }

    public static class MyReducer
    extends MapReduceBase
    implements Reducer<IntWritable, Text, IntWritable, Text> {
        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                output.collect((Object)key, (Object)new Text(values.next().toString()));
            }
        }
    }
}

