/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import kr.ac.kaist.itcknow.bigml.algo.hadoop.Dataset;

public class GenFeatureData {
    public static void main(String[] args) throws IOException {
        args = new String[]{"G:/data/fedis/kddb/kddb.train", "1024"};
        if (args.length != 2) {
            System.out.println("Wrong number of input arguments");
            System.exit(-1);
        }
        String[] scaleArray = new String[]{"1024", "256", "64", "16", "4", "1"};
        for (int i = 0; i < scaleArray.length; ++i) {
            GenFeatureData.run(args[0], scaleArray[i]);
        }
    }

    private static void run(String args0, String args1) throws IOException {
        String inPath = args0;
        int scale = Integer.parseInt(args1);
        Dataset ds = new Dataset(inPath);
        int D = ds.getD();
        int N = ds.getN();
        String dataType = ds.getDataType();
        String expt = "DPSCD.feature.split";
        System.out.println("Running.... [" + expt + "] " + dataType + "\tN=" + N + "\tD=" + D);
        String outPath = inPath.replace(".train", "." + scale + ".train");
        int maxDimensionNumber = D / scale;
        System.out.println("Max Dimension Number: " + maxDimensionNumber);
        String line = null;
        String newLine = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inPath)));
        BufferedWriter bw = new BufferedWriter(new FileWriter(outPath));
        while ((line = br.readLine()) != null && !line.equals("")) {
            newLine = "";
            String[] tkns = line.split(" ");
            String label = tkns[0];
            newLine = newLine + label + " ";
            for (int i = 1; i < tkns.length; ++i) {
                String[] tkns2 = tkns[i].split(":");
                int dim = Integer.parseInt(tkns2[0]);
                String value = tkns2[1];
                if (dim > maxDimensionNumber) continue;
                newLine = newLine + dim + ":" + value + " ";
            }
            newLine = newLine.trim();
            bw.write(newLine + "\n");
        }
        bw.close();
        br.close();
        System.out.println("scale file generated: " + outPath);
    }
}

