/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.itcknow.bigml.algo.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import kr.ac.kaist.itcknow.bigml.algo.hadoop.Dataset;
import kr.ac.kaist.itcknow.bigml.algo.multicore.sgd.LRSGD;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DSGD
extends Configured
implements Tool {
    public static Logger logger = Logger.getLogger(DSGD.class);
    static String hdfsPath = "hdfs://172.20.1.1:9000/user/dykang/";

    protected JobConf THadoopDSGD(Path inPath, Path outPath, int nreducers, int D, int itr, String expt, String dataType) throws Exception {
        JobConf conf = new JobConf(this.getConf(), DSGD.class);
        conf.setJobName(String.format("[DSGD][ITR-%d][%s] D=%d", itr, dataType, D));
        conf.set("nreducers", "" + nreducers);
        conf.set("d", "" + D);
        conf.set("itr", "" + itr);
        conf.set("outPath", "" + outPath);
        conf.set("expt", "" + expt);
        conf.set("dataType", "" + dataType);
        long milliSecionds = 0L;
        conf.setLong("mapred.task.timeout", milliSecionds);
        logger.info((Object)String.format("[DSGD][ITR-%d][%s] D=%d", itr, dataType, D));
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(MyMapper.class);
        conf.setPartitionerClass(MyPartitioner.class);
        conf.setReducerClass(THadoopDSGDMyReducer.class);
        conf.setNumReduceTasks(nreducers);
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inPath});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        return conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 4) {
            System.exit(DSGD.printUsage());
        }
        Path inPath = new Path(args[0]);
        Path outPath = new Path(args[1]);
        int nreducers = Integer.parseInt(args[2]);
        int hadoopitr = Integer.parseInt(args[3]);
        Dataset ds = new Dataset(inPath);
        int D = ds.getD();
        int N = ds.getN();
        String dataType = ds.getDataType();
        String expt = "DSGD";
        System.out.println("Running.... [" + expt + "] " + dataType + "\tD=" + D + "\tC=" + "");
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        String local_output_path = "./output/dsgd.local";
        local_output_path = local_output_path + "/" + hadoopitr + "/";
        outPath = new Path(outPath.toString() + "/" + hadoopitr + "/");
        expt = expt + "_" + hadoopitr;
        for (int itr = 1; itr <= hadoopitr; ++itr) {
            long start = System.currentTimeMillis();
            JobClient.runJob((JobConf)this.THadoopDSGD(inPath, new Path(outPath.toString() + "/" + itr), nreducers, D, itr, expt, dataType));
            long end = System.currentTimeMillis();
            FileUtil.fullyDelete((File)new File(local_output_path + itr + "/"));
            fs.copyToLocalFile(new Path(outPath.toString() + "/" + itr + "/"), new Path(local_output_path + itr + "/"));
            String[] args2 = ("--x " + dataType + " --f " + inPath.toString() + " --f " + hdfsPath + inPath.toString() + " --tt " + hdfsPath + inPath.toString().replace("train", "test") + " --i " + 1).split(" ");
            PosixParser parser = new PosixParser();
            LRSGD.InitOptions();
            CommandLine cli = parser.parse(LRSGD.options, args2);
            LRSGD lr = new LRSGD(cli);
            lr.dim = D;
            lr.init();
            lr.mergeParams(local_output_path + itr + "/");
            lr.printParams(String.format("%s%s.params", local_output_path, expt + "_" + itr));
            fs.copyFromLocalFile(new Path(String.format("%s%s.params", local_output_path, expt + "_" + itr)), new Path(outPath.toString()));
            if (dataType.equals("rcv1") || dataType.equals("arcene") || dataType.equals("news20") || dataType.equals("zeta") || dataType.equals("a9") || dataType.equals("kdda") || dataType.equals("kddb")) {
                System.out.println(String.format("Iteration:%d\tTime:%d", itr, (end - start) / 1000L));
                continue;
            }
            if (!dataType.equals("1") && !dataType.equals("2") && !dataType.equals("3")) continue;
            System.out.println(String.format("Iteration:%d\tTime:%d", itr, (end - start) / 1000L));
        }
        return 0;
    }

    private static int printUsage() {
        System.out.println("DSGD <in_path> <out_path> <nreducers> <hditr>");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
        return -1;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"./log4j.properties");
        logger.info((Object)"DSGD running....");
        int result = ToolRunner.run((Configuration)new Configuration(), (Tool)new DSGD(), (String[])args);
        System.exit(result);
    }

    public static class MyPartitioner<V2>
    implements Partitioner<IntWritable, V2> {
        public void configure(JobConf job) {
            logger.info((Object)String.format("[DSGD][Partition]", new Object[0]));
        }

        public int getPartition(IntWritable key, V2 value, int numReduceTasks) {
            int partition = key.get() % numReduceTasks;
            return partition;
        }
    }

    public static class MyMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, IntWritable, Text> {
        int nreducers;
        int D;
        int itr;
        String dataType;

        public void configure(JobConf job) {
            this.nreducers = Integer.parseInt(job.get("nreducers"));
            this.itr = Integer.parseInt(job.get("itr"));
            this.dataType = job.get("dataType");
            this.D = Integer.parseInt(job.get("d"));
            logger.info((Object)String.format("[DSGD][ITR-%d][Map][%s] D=%d", this.itr, this.dataType, this.D));
        }

        public void map(LongWritable key, Text value, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            int partitionIndex = (int)(Math.random() * (double)this.nreducers);
            output.collect((Object)new IntWritable(partitionIndex), (Object)value);
        }
    }

    public static class THadoopDSGDMyReducer
    extends MapReduceBase
    implements Reducer<IntWritable, Text, IntWritable, Text> {
        int D;
        int itr;
        String expt;
        String outPath;
        String dataType;

        public void configure(JobConf job) {
            this.D = Integer.parseInt(job.get("d"));
            this.itr = Integer.parseInt(job.get("itr"));
            this.outPath = job.get("outPath");
            this.expt = job.get("expt");
            this.dataType = job.get("dataType");
            logger.info((Object)String.format("[DSGD][ITR-%d][Reduce][%s] D=%d", this.itr, this.dataType, this.D));
        }

        public void reduce(IntWritable key, Iterator<Text> values, OutputCollector<IntWritable, Text> output, Reporter reporter) throws IOException {
            LRSGD lr = null;
            String returnStr = "";
            try {
                String[] args = ("--x " + this.dataType + " --i " + 1).split(" ");
                PosixParser parser = new PosixParser();
                LRSGD.InitOptions();
                CommandLine cli = parser.parse(LRSGD.options, args);
                lr = new LRSGD(cli);
                int nInstance = 0;
                lr.dim = this.D;
                lr.num_label = 2;
                lr.init();
                if (this.itr > 1) {
                    Path pt = new Path(String.format(hdfsPath + "%s/%s.params", this.outPath.substring(0, this.outPath.toString().lastIndexOf("/")), this.expt + "_" + (this.itr - 1)));
                    FileSystem fs = FileSystem.get((Configuration)new Configuration());
                    lr.readParams(new InputStreamReader((InputStream)fs.open(pt)));
                }
                while (values.hasNext()) {
                    ++nInstance;
                    int startIndex = 0;
                    if (lr.isHadoopGeneratedData) {
                        startIndex = 1;
                    }
                    String[] tokens = values.next().toString().split(lr.dataDeliminator);
                    int y = lr.getIndex(lr.label_index, tokens[startIndex]);
                    double[] feature_vector = new double[lr.dim];
                    for (int i = startIndex + 1; i < tokens.length; ++i) {
                        String[] toks = tokens[i].split(":");
                        int feature = lr.getFeatureIndex(toks[0]);
                        feature_vector[feature] = Double.parseDouble(toks[1]);
                    }
                    lr.trainOneInstance(y, feature_vector);
                }
                lr.num_instance = nInstance;
                returnStr = returnStr + nInstance + ":" + lr.num_label + ":" + lr.dim + lr.getParamFormatString();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            output.collect((Object)key, (Object)new Text(returnStr));
        }
    }
}

