#include <cstdlib>
#include <exception>
#include <iostream>
#include <string>
#include <dlrCommon/exception.h>
#include <dlrUtilities/path.h>
#include "CompleterAppX11.hh"

// Note(xxx): Non-portable code here.
#include <sys/stat.h>
#include <sys/types.h>


const std::string s_defaultConfigDirectoryName = ".xComplete2";

std::string
setupConfig(const char* homeDirectoryCStr)
{
  // If all else fails, we'll put/use the config in the current
  // directory.
  std::string configDirectoryName = s_defaultConfigDirectoryName;

  // OTOH, if we can figure out the user's home directory, use that.
  if(homeDirectoryCStr) {
    configDirectoryName =
      dlr::joinPath(homeDirectoryCStr, configDirectoryName);
  }

  // Create the config dir if it doesn't exist already.
  if(!dlr::isDirectory(configDirectoryName)) {
    // Note(xxx): Non-portable code here.
    if(mkdir(configDirectoryName.c_str(), 0700) != 0) {
      std::ostringstream message;
      message << "Failed to create config directory:\n  "
              << configDirectoryName
              << "\nPerhaps the environment variale HOME is set incorrectly.";
      DLR_THROW(dlr::IOException, "setupConfig()", message.str().c_str());
    }
  }
  return configDirectoryName;
}


int
main(int argc, char* argv[])
{
  std::string configDirectoryName = setupConfig(std::getenv("HOME"));

//   try {
    xComplete::CompleterAppX11 app(configDirectoryName);
    app.run();
    app.saveHistory();
//   } catch(const dlr::Exception& caughtException) {
//     std::cerr << "[" << argv[0] << "] Caught an exception: \n"
//               << caughtException.what() << std::endl;
//     exit(1);
//   } catch(const std::exception& caughtException) {
//     std::cerr << "[" << argv[0] << "] Caught a std::exception: \n"
//               << caughtException.what() << std::endl;
//     exit(2);
//   } catch(...) {
//     std::cerr << "[" << argv[0] << "] Caught an unexpected exception."
//               << std::endl;
//     exit(3);
//   }
  exit(0);
}
