/**
***************************************************************************
* @file version.hh
*
* Header file defining version string.  Other source files should
* include this file in order to access global version information.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
***************************************************************************
**/

#ifndef _XCOMPLETE_VERSION_H_
#define _XCOMPLETE_VERSION_H_

/**
 ** All symbols specific to the xComplete2 application go in this
 ** namespace.
 **/
namespace xComplete {

  /** 
   * This function provides access to the global version string.
   * 
   * @return The return value is a reference to const std::string
   * indicating the version number of the program, for example "0.1"
   * or "2.3".
   */
  inline const std::string&
  getVersionString() {
    static const std::string versionString = "0.2";
    return versionString;
  }
    
} // namespace xComplete

#endif /* #ifndef _XCOMPLETE_VERSION_H_ */
