/**
***************************************************************************
* @file ModifierTag.hh
* Header file declaring ModifierTag enum.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
***************************************************************************
**/

#ifndef _XCOMPLETE_MODIFIERTAG_H_
#define _XCOMPLETE_MODIFIERTAG_H_

#include <X11/X.h>
#include "X11Interface.hh"

namespace xComplete {

  /**
   ** This enum represents the available modifier keys, such as
   ** shift, control, etc.
   **/
  enum ModifierTag {
    MODIFIER_NONE = 0x0000,
    MODIFIER_LEFT_SHIFT = 0x0001,
    MODIFIER_RIGHT_SHIFT = 0x0002,
    MODIFIER_SHIFT = 0x0003,
    MODIFIER_LEFT_CONTROL = 0x0004,
    MODIFIER_RIGHT_CONTROL = 0x0008,
    MODIFIER_CONTROL = 0x000C,
    MODIFIER_LEFT_MODIFIER1 = 0x0010,    // Usually MODIFIER1 is "Alt".
    MODIFIER_RIGHT_MODIFIER1 = 0x0020,
    MODIFIER_MODIFIER1 = 0x0030,
    MODIFIER_LEFT_MODIFIER2 = 0x0040,
    MODIFIER_RIGHT_MODIFIER2 = 0x0080,
    MODIFIER_MODIFIER2 = 0x00C0,
    MODIFIER_LEFT_MODIFIER3 = 0x0100,
    MODIFIER_RIGHT_MODIFIER3 = 0x0200,
    MODIFIER_MODIFIER3 = 0x0300,
    MODIFIER_LEFT_MODIFIER4 = 0x0400,
    MODIFIER_RIGHT_MODIFIER4 = 0x0800,
    MODIFIER_MODIFIER4 = 0x0C00,
    MODIFIER_LEFT_MODIFIER5 = 0x1000,
    MODIFIER_RIGHT_MODIFIER5 = 0x2000,
    MODIFIER_MODIFIER5 = 0x3000,
    MODIFIER_CAPS_LOCK = 0x4000
  };

} // namespace xComplete

#endif /* #ifndef _XCOMPLETE_MODIFIERTAG_H_ */
