/**
***************************************************************************
* @file CompleterAppX11.hh
* Header file declaring CompleterAppX11 class.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
* 
* $Log: $
***************************************************************************
**/

#ifndef _XCOMPLETE_COMPLETERAPPX11_H_
#define _XCOMPLETE_COMPLETERAPPX11_H_

#include "CompleterAppFltk.hh"
#include "KeyDescription.hh"
#include "WindowDescription.hh"
#include "X11Interface.hh"

namespace xComplete {

  /**
   ** This class specializes the CompleterAppFltk class to work with
   ** the X Window System.
   **/
  class CompleterAppX11
    : public CompleterAppFltk
  {
  public:

    CompleterAppX11(const std::string& configFileName);


    virtual
    ~CompleterAppX11();


    virtual bool
    checkForKeystroke(KeyDescription& keyDescription,
                      WindowDescription& windowDescription);

    
  protected:
    
    virtual void
    sendKeySequence(const std::vector<KeyDescription>& currentWord,
                    const WindowDescription& windowDescription);


  protected:

    X11Interface m_X11Interface;
    
  }; // class CompleterApp


  /* ============== Non-member function declarations ============== */
  

} // namespace xComplete

/* ============ Definitions of inline & template functions ============ */

namespace xComplete {

  // Empty.
  
} // namespace xComplete

#endif /* #ifndef _XCOMPLETE_COMPLETERAPP_H_ */
