/**
***************************************************************************
* @file CompleterAppX11.cc
* Source file declaring CompleterAppX11 class.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
* 
* $Log: $
***************************************************************************
**/

#include "CompleterAppX11.hh"

namespace xComplete {


  CompleterAppX11::
  CompleterAppX11(const std::string& configFileName)
    : CompleterAppFltk(configFileName),
      m_X11Interface()
  {
    // Empty
  }


  CompleterAppX11::
  ~CompleterAppX11()
  {
    // Empty
  }

  
  bool
  CompleterAppX11::
  checkForKeystroke(KeyDescription& keyDescription,
                    WindowDescription& windowDescription)
  {
    return m_X11Interface.checkForKeystroke(keyDescription, windowDescription);
  }

    
  void
  CompleterAppX11::
  sendKeySequence(const std::vector<KeyDescription>& completion,
                  const WindowDescription& windowDescription)
  {
    for(size_t index0 = 0; index0 < completion.size(); ++index0) {
      m_X11Interface.sendKeystroke(completion[index0], windowDescription);
    }
  }

    
} // namespace xComplete
