// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "CompleterAppFltk.hh"
#include <dlrPortability/timeUtilities.h>
#include <dlrUtilities/path.h>
#include <dlrUtilities/stringManipulation.h>

void CompleterAppFltk::cb_m_mainWindowPtr_i(Fl_Double_Window*, void*) {
  // xxx
std::cout << "m_mainWindowPtr callback executing..." << std::endl;
this->m_exit = true;
}
void CompleterAppFltk::cb_m_mainWindowPtr(Fl_Double_Window* o, void* v) {
  ((CompleterAppFltk*)(o->user_data()))->cb_m_mainWindowPtr_i(o,v);
}

void CompleterAppFltk::cb_Configure_i(Fl_Menu_*, void*) {
  this->m_configurationWindowPtr->show();
}
void CompleterAppFltk::cb_Configure(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_Configure_i(o,v);
}

void CompleterAppFltk::cb_Exit_i(Fl_Menu_*, void*) {
  this->m_exit = true;
}
void CompleterAppFltk::cb_Exit(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_Exit_i(o,v);
}

void CompleterAppFltk::cb_Add_i(Fl_Menu_*, void*) {
  this->addNextWindow();
}
void CompleterAppFltk::cb_Add(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_Add_i(o,v);
}

void CompleterAppFltk::cb_m_pauseMenuItemPtr_i(Fl_Menu_*, void*) {
  if(m_pauseMenuItemPtr->value()) {
  this->pause();
} else {
  this->resume();
};
}
void CompleterAppFltk::cb_m_pauseMenuItemPtr(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_m_pauseMenuItemPtr_i(o,v);
}

void CompleterAppFltk::cb_Intro_i(Fl_Menu_*, void*) {
  m_helpWindowPtr->show();
}
void CompleterAppFltk::cb_Intro(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_Intro_i(o,v);
}

void CompleterAppFltk::cb_About_i(Fl_Menu_*, void*) {
  std::string creditString = dlr::replaceString(this->getCredits(), "@", "@@");
fl_message(creditString.c_str());
}
void CompleterAppFltk::cb_About(Fl_Menu_* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_About_i(o,v);
}

Fl_Menu_Item CompleterAppFltk::menu_[] = {
 {"File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Configure...", 0,  (Fl_Callback*)CompleterAppFltk::cb_Configure, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Exit", 0,  (Fl_Callback*)CompleterAppFltk::cb_Exit, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Actions", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Add window", 0,  (Fl_Callback*)CompleterAppFltk::cb_Add, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Pause", 0,  (Fl_Callback*)CompleterAppFltk::cb_m_pauseMenuItemPtr, 0, 2, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Help", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Intro...", 0,  (Fl_Callback*)CompleterAppFltk::cb_Intro, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"About...", 0,  (Fl_Callback*)CompleterAppFltk::cb_About, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* CompleterAppFltk::m_pauseMenuItemPtr = CompleterAppFltk::menu_ + 6;

void CompleterAppFltk::cb_m_closeConfigButtonPtr_i(Fl_Button*, void*) {
  m_learnCompletionKeysButtonPtr->value(0);
m_learnModifierKeysButtonPtr->value(0);
m_learnSeparatorKeysButtonPtr->value(0);
m_configurationWindowPtr->hide();
}
void CompleterAppFltk::cb_m_closeConfigButtonPtr(Fl_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_m_closeConfigButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_saveConfigButtonPtr_i(Fl_Button*, void*) {
  try {
  m_config.save(m_configFileName);
} catch(const dlr::IOException& caughtException) {
  std::ostringstream buffer;
  buffer << "Couldn't save current configuration to file\n"
         << "m_configFileName\n"
         << "Error was:\n"
         << caughtException.what();
  fl_alert(buffer.str().c_str());
};
}
void CompleterAppFltk::cb_m_saveConfigButtonPtr(Fl_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_m_saveConfigButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_learnBackspaceKeysButtonPtr_i(Fl_Check_Button*, void*) {
  if(m_learnBackspaceKeysButtonPtr->value() == 1) {
  this->m_learnCompletionKeysButtonPtr->value(0);  
  this->m_learnModifierKeysButtonPtr->value(0);
  this->m_learnSeparatorKeysButtonPtr->value(0);
  this->startLearningKeystrokes();
} else {
  this->stopLearningKeystrokes();
  this->setBackspaceKeystrokes(
    this->removeModifiers(this->getLearnedKeystrokes()));
};
}
void CompleterAppFltk::cb_m_learnBackspaceKeysButtonPtr(Fl_Check_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_learnBackspaceKeysButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_learnCompletionKeysButtonPtr_i(Fl_Check_Button*, void*) {
  if(m_learnCompletionKeysButtonPtr->value() == 1) {
  this->m_learnBackspaceKeysButtonPtr->value(0);  
  this->m_learnModifierKeysButtonPtr->value(0);
  this->m_learnSeparatorKeysButtonPtr->value(0);
  this->startLearningKeystrokes();
} else {
  this->stopLearningKeystrokes();
  this->setCompletionKeystrokes(
    this->removeModifiers(this->getLearnedKeystrokes()));
};
}
void CompleterAppFltk::cb_m_learnCompletionKeysButtonPtr(Fl_Check_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_learnCompletionKeysButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_learnModifierKeysButtonPtr_i(Fl_Check_Button*, void*) {
  if(m_learnModifierKeysButtonPtr->value() == 1) {
  this->m_learnBackspaceKeysButtonPtr->value(0);  
  this->m_learnCompletionKeysButtonPtr->value(0);  
  this->m_learnSeparatorKeysButtonPtr->value(0);
  this->startLearningKeystrokes();
} else {
  this->stopLearningKeystrokes();
  this->setModifierKeystrokes(this->getLearnedKeystrokes());
};
}
void CompleterAppFltk::cb_m_learnModifierKeysButtonPtr(Fl_Check_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_learnModifierKeysButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_learnSeparatorKeysButtonPtr_i(Fl_Check_Button*, void*) {
  if(m_learnSeparatorKeysButtonPtr->value() == 1) {
  this->m_learnBackspaceKeysButtonPtr->value(0);  
  this->m_learnCompletionKeysButtonPtr->value(0);  
  this->m_learnModifierKeysButtonPtr->value(0);
  this->startLearningKeystrokes();
} else {
  this->stopLearningKeystrokes();
  this->setSeparatorKeystrokes(
    this->removeModifiers(this->getLearnedKeystrokes()));
};
}
void CompleterAppFltk::cb_m_learnSeparatorKeysButtonPtr(Fl_Check_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_learnSeparatorKeysButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_backspaceRequiredButtonPtr_i(Fl_Check_Button*, void*) {
  m_config.setCompletionKeyBackspaceRequired(static_cast<bool>(m_backspaceRequiredButtonPtr->value()));
}
void CompleterAppFltk::cb_m_backspaceRequiredButtonPtr(Fl_Check_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_backspaceRequiredButtonPtr_i(o,v);
}

void CompleterAppFltk::cb_m_regexEditorPtr_i(Fl_Text_Editor*, void*) {
  m_saveConfigButtonPtr->deactivate();
m_closeConfigButtonPtr->deactivate();
}
void CompleterAppFltk::cb_m_regexEditorPtr(Fl_Text_Editor* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_m_regexEditorPtr_i(o,v);
}

void CompleterAppFltk::cb_Accept_i(Fl_Button*, void*) {
  const char* regexEditorText = m_regexEditorPtr->buffer()->text();
std::vector<std::string> regexStringVector = dlr::splitString(regexEditorText, "\n");
free((void*)regexEditorText);

this->clearWindowNamePatterns();
for(size_t index0 = 0; index0 < regexStringVector.size(); ++index0) {
  this->addWindowNamePattern(regexStringVector[index0]);
}

m_saveConfigButtonPtr->activate();
m_closeConfigButtonPtr->activate();
}
void CompleterAppFltk::cb_Accept(Fl_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_Accept_i(o,v);
}

void CompleterAppFltk::cb_Cancel_i(Fl_Button*, void*) {
  std::string regexEditorString = dlr::joinString(m_config.getWindowNamePatterns(), "\n");
m_regexEditorPtr->buffer()->text(regexEditorString.c_str());
m_saveConfigButtonPtr->activate();
m_closeConfigButtonPtr->activate();
}
void CompleterAppFltk::cb_Cancel(Fl_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->parent()->parent()->user_data()))->cb_Cancel_i(o,v);
}

void CompleterAppFltk::cb_Close_i(Fl_Button*, void*) {
  m_helpWindowPtr->hide();
}
void CompleterAppFltk::cb_Close(Fl_Button* o, void* v) {
  ((CompleterAppFltk*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

CompleterAppFltk::CompleterAppFltk(const std::string& configDirectoryName) {
  Fl_Double_Window* w;
  m_configFileName = dlr::joinPath(
  configDirectoryName, this->getDefaultConfigFileName());
m_databaseFileName = dlr::joinPath(
  configDirectoryName, this->getDefaultDatabaseFileName());
m_exit = false;
m_helpTextBufferPtr = 0;
m_regexTextBufferPtr = 0;
  { Fl_Double_Window* o = m_mainWindowPtr = new Fl_Double_Window(220, 55, "xComplete2");
    w = o;
    o->callback((Fl_Callback*)cb_m_mainWindowPtr, (void*)(this));
    { Fl_Output* o = m_textOutputPtr = new Fl_Output(5, 25, 210, 25);
      Fl_Group::current()->resizable(o);
    }
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(0, 0, 220, 20);
      o->menu(menu_);
    }
    o->end();
  }
  { Fl_Double_Window* o = m_suggestionWindowPtr = new Fl_Double_Window(155, 20);
    w = o;
    o->user_data((void*)(this));
    m_suggestionOutputPtr = new Fl_Output(0, 0, 155, 20);
    o->end();
    o->resizable(o);
  }
  { Fl_Double_Window* o = m_configurationWindowPtr = new Fl_Double_Window(340, 225, "xComplete2 Configuration");
    w = o;
    o->user_data((void*)(this));
    { Fl_Button* o = m_closeConfigButtonPtr = new Fl_Button(260, 200, 70, 20, "Close");
      o->tooltip("Press this button to close the configuration window.  Your configuration chan\
ges will be preserved for this session, but won\'t be saved for future session\
s unless you press (or have pressed) the \"Save\" button.");
      o->callback((Fl_Callback*)cb_m_closeConfigButtonPtr);
    }
    { Fl_Button* o = m_saveConfigButtonPtr = new Fl_Button(185, 200, 70, 20, "Save");
      o->tooltip("Press this button to save your current configuration for use in future invoca\
tions of the program.");
      o->callback((Fl_Callback*)cb_m_saveConfigButtonPtr);
    }
    { Fl_Tabs* o = new Fl_Tabs(5, 5, 329, 190);
      { Fl_Group* o = new Fl_Group(5, 30, 320, 165, "Keys");
        { Fl_Check_Button* o = m_learnBackspaceKeysButtonPtr = new Fl_Check_Button(15, 115, 70, 15, "Learn Backspace Keys");
          o->tooltip("Check this box, then type any key combinations which generate backspaces, the\
n uncheck this box.\\nNote that modifier keys will be ignored.");
          o->down_box(FL_DOWN_BOX);
          o->callback((Fl_Callback*)cb_m_learnBackspaceKeysButtonPtr);
        }
        { Fl_Check_Button* o = m_learnCompletionKeysButtonPtr = new Fl_Check_Button(15, 65, 70, 15, "Learn Completion Keys");
          o->tooltip("Check this box, then type any key combinations you\'d like to use as completi\
on keys, then uncheck this box.\\nNote that modifier keys will be ignored.");
          o->down_box(FL_DOWN_BOX);
          o->callback((Fl_Callback*)cb_m_learnCompletionKeysButtonPtr);
        }
        { Fl_Check_Button* o = m_learnModifierKeysButtonPtr = new Fl_Check_Button(15, 40, 70, 15, "Learn Modifier Keys");
          o->tooltip("Check this box, then press SHIFT, then press ALT, and so on for all of the mo\
difier keys on your keyboard, then uncheck this box.");
          o->down_box(FL_DOWN_BOX);
          o->callback((Fl_Callback*)cb_m_learnModifierKeysButtonPtr);
        }
        { Fl_Check_Button* o = m_learnSeparatorKeysButtonPtr = new Fl_Check_Button(15, 140, 70, 15, "Learn Separator Keys");
          o->tooltip("Check this box, then type any key combinations you\'d like to treat as word s\
eparators (such as whitespace, punctuation, etc.) then uncheck this box.\\nNot\
e that modifier keys will be ignored.");
          o->down_box(FL_DOWN_BOX);
          o->callback((Fl_Callback*)cb_m_learnSeparatorKeysButtonPtr);
        }
        { Fl_Check_Button* o = m_backspaceRequiredButtonPtr = new Fl_Check_Button(35, 90, 64, 15, "Completion Key Needs Backspace");
          o->tooltip("Check this box if the keystrokes you\'re using as completion keys actually ge\
nerate printable characters.  If this box is checked, each automatically gener\
ated completion will start with a backspace in order to erase the character in\
troduced by pressing the completion key.");
          o->down_box(FL_DOWN_BOX);
          o->callback((Fl_Callback*)cb_m_backspaceRequiredButtonPtr);
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(5, 30, 329, 165, "Regex");
        o->hide();
        { Fl_Text_Editor* o = m_regexEditorPtr = new Fl_Text_Editor(10, 35, 320, 130);
          o->tooltip("Enter one regular expression per line.  Completion will be performed in windo\
ws whose names match the entered regexes.  For example, if you enter \".*\\.[C\
c]\" (without the quotes) on one line, then completion will be performed in wi\
ndows with names like \"foo.c\" and \"bar.C\".");
          o->callback((Fl_Callback*)cb_m_regexEditorPtr);
          o->when(FL_WHEN_CHANGED);
        }
        { Fl_Button* o = new Fl_Button(15, 170, 90, 20, "Accept Edits");
          o->tooltip("Press this button to accept any changes you\'ve made in the regex editor.  Th\
e changes will be adopted for this session, but won\'t be saved for future ses\
sions unless you press the \"Save\" button.");
          o->callback((Fl_Callback*)cb_Accept);
        }
        { Fl_Button* o = new Fl_Button(235, 170, 90, 20, "Cancel Edits");
          o->tooltip("Press this button to discard any edits you\'ve made in the regex editor.");
          o->callback((Fl_Callback*)cb_Cancel);
        }
        o->end();
      }
      o->end();
    }
    o->end();
    o->resizable(o);
  }
  { Fl_Double_Window* o = m_helpWindowPtr = new Fl_Double_Window(500, 565);
    w = o;
    o->user_data((void*)(this));
    { Fl_Text_Display* o = m_helpTextDisplayPtr = new Fl_Text_Display(5, 5, 490, 530);
      Fl_Group::current()->resizable(o);
    }
    { Fl_Button* o = new Fl_Button(430, 540, 64, 20, "Close");
      o->callback((Fl_Callback*)cb_Close);
    }
    o->end();
  }
  m_mainWindowPtr->show();

try {
  this->loadConfig();
} catch(const dlr::IOException& caughtException) {
  m_configurationWindowPtr->hotspot(0, 0);
  m_configurationWindowPtr->show();
  fl_alert("Couldn't load config file.  Please configure & save.");
  this->displayStatus(caughtException.what());
}

try {
  this->loadHistory();
} catch(const dlr::IOException& caughtException) {
  fl_alert("Couldn't load database file.  One will be created for you.");
  this->displayStatus(caughtException.what());
}

m_backspaceRequiredButtonPtr->value(m_config.isCompletionKeyBackspaceRequired());

std::string regexEditorString = dlr::joinString(m_config.getWindowNamePatterns(), "\n");
m_regexTextBufferPtr = new Fl_Text_Buffer(regexEditorString.size());
m_regexTextBufferPtr->text(regexEditorString.c_str());
m_regexEditorPtr->buffer(m_regexTextBufferPtr);

std::string helpString = dlr::wrapString(this->getHelpString());
m_helpTextBufferPtr = new Fl_Text_Buffer(helpString.size());
m_helpTextBufferPtr->text(helpString.c_str());
m_helpTextDisplayPtr->buffer(m_helpTextBufferPtr);

this->displayStatus("Waiting for keystrokes...");
}

CompleterAppFltk::~CompleterAppFltk() {
  delete m_helpTextBufferPtr;
delete m_regexTextBufferPtr;
}

std::string CompleterAppFltk::getCredits() {
  std::string creditsString = CompleterApp::getCredits();
creditsString += "\n\nUser interface implemented using FLTK\n"
                 "(http://www.fltk.org).";
return creditsString;
}

void CompleterAppFltk::run() {
  while(1) {
  xComplete::KeyDescription keyDescription;
  xComplete::WindowDescription windowDescription;
  this->runOneIteration(keyDescription, windowDescription);
  Fl::check();
  if(m_exit) {
    break;
  }
  dlr::portability::preciseSleep(30);
}
}
// ==== Protected members below this line ====

void CompleterAppFltk::displayStatus(const std::string& message) {
  m_textOutputPtr->value(message.c_str());
}

void CompleterAppFltk::showSuggestion(const std::string& suggestion) {
  if(suggestion == "") {
  m_suggestionWindowPtr->hide();
} else {
  // int xSize = m_suggestionWindowPtr->w();
  int ySize = m_suggestionWindowPtr->h();
  m_suggestionWindowPtr->hotspot(-3, ySize + 10);
  m_suggestionWindowPtr->show();
  m_suggestionOutputPtr->value(suggestion.c_str());
}
Fl::check();
}
// ==== Data members below this line ====
