/**
***************************************************************************
* @file dlrUtilities/exception.h
*
* Header file declaring some exception types and providing namespace
* documentation.
*
* Copyright (c) 2007, David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#ifndef _DLR_UTILITIES_EXCEPTION_H_
#define _DLR_UTILITIES_EXCEPTION_H_

#include <dlrCommon/exception.h>

namespace dlr {

  /**
   ** This namespace contains general utility functions and classes
   ** for string manipluation, program option parsing, working with
   ** time and filenames, and a few other odds and ends.
   **/
  namespace utilities {
  
    /**
     ** This is an Exception class for errors involving failed
     ** conversions from one type to another.
     **/
    DLR_DECLARE_EXCEPTION_TYPE(ConversionException, ValueException);

  } // namespace utilities

} // namespace dlr

#endif // #ifndef _DLR_UTILITIES_EXCEPTION_H_
