/**
***************************************************************************
* @file dlrThread/private.h Header file declaring utility routines
* which should be considered private to the dlrThread library.  Client
* code should not use or rely on these routines.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#ifndef _DLR_THREAD_PRIVATE_H_
#define _DLR_THREAD_PRIVATE_H_

#include <dlrCommon/exception.h>

namespace dlr {

  namespace thread {

    // This private function returns by reference boost::xtime
    // instance that represents a time that is timeout seconds in the
    // future.
    inline bool
    getXTime(double timeout, boost::xtime& xtimeout)
    {
      if(boost::xtime_get(&xtimeout, boost::TIME_UTC) == 0) {
        // Couldn't get the current time.
        return false;
      }
      long int seconds = static_cast<long int>(timeout);
      long int nanoSeconds = static_cast<long int>(
        (timeout - seconds) * 1000000000);
      xtimeout.sec += seconds;
      xtimeout.nsec += nanoSeconds;
      while(xtimeout.nsec >= 1000000000) {
        ++(xtimeout.sec);
        xtimeout.nsec -= 1000000000;
      }
      while(xtimeout.nsec < 0) {
        --(xtimeout.sec);
        xtimeout.nsec += 1000000000;
      }
      return true;
    }

  } // namespace thread

} // namespace dlr

#endif /* #ifndef _DLR_THREAD_CLIENTID_H_ */
