/**
***************************************************************************
* @file dlrTest/testException.h
*
* Header file declaring a specialization of dlr::Exception which will
* be thrown to indicate failed unit tests.
*
* Copyright (C) 2003-2004, David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 884 $
* $Date: 2007-05-04 00:49:37 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_TESTEXCEPTION_H_
#define _DLR_TESTEXCEPTION_H_

#include <dlrCommon/exception.h>


namespace dlr {

  /**
   ** This namespace contains a unit testing library.
   **/
  namespace test {

    /**
     ** This exception is thrown to indicate a failed test.  It is
     ** mostly thrown by the DLR_TEST_ASSERT() macro, or it can be
     ** thrown explicitly by the test code.
     **/
    class TestException : public Exception {
    public:
      /** 
       * Default constructor.
       */
      TestException() throw()
        : Exception("", "TestException") {}


      /** 
       * This constructor sets the internal "what()" message.  This message
       * should generally provide information about the test failure.
       * 
       * @param message This argument specifies the text of the message.
       */
      TestException(const char* message) throw()
        : Exception(message, "TestException") {}


      /** 
       * This constructor builds the internal "what()" message using
       * detailed information about the failure.
       * 
       * @param message This argument specifies a description of the failure.
       * 
       * @param fileName This argument specifies the name of the file in
       * which the failure occurred.
       * 
       * @param lineNumber This argument specifies the line number at
       * which the failure occurred.
       */
      TestException(const char* message, const char* fileName,
                    int lineNumber) throw()
        : Exception(message, "TestException", 0, fileName, lineNumber) {}


      /** 
       * This constructor builds the internal "what()" message using
       * detailed information about the failure.
       * 
       * @param message This argument specifies a description of the failure.
       * 
       * @param functionName This argument specifies the name of the function
       * in which the failure occurred.
       * 
       * @param fileName This argument specifies the name of the file in
       * which the failure occurred.
       * 
       * @param lineNumber This argument specifies the line number at
       * which the failure occurred.
       */
      TestException(const char* message, const char* functionName,
                    const char* fileName, int lineNumber) throw()
        : Exception(message, "TestException", functionName, fileName,
                    lineNumber) {}


      /** 
       * The copy constructor deep copies its argument.
       * 
       * @param source This argument is the class instance to be copied.
       */
      TestException(const TestException& source) throw()
        : Exception(source) {}


      /** 
       * Destructor.
       */
      virtual ~TestException() throw() {}
    };

  } // namespace test
  
} // namespace dlr


/* ======= Declarations to maintain compatibility with legacy code. ======= */

namespace dlr {

  using test::TestException;
  
} // namespace dlr


#endif // #ifndef _DLR_TESTEXCEPTION_H_
