/**
***************************************************************************
* @file transform2DTest.cpp
* 
* Source file defining Transform2DTest class.
*
* Copyright (C) 2004-2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 939 $
* $Date: 2007-06-09 13:08:18 -0400 (Sat, 09 Jun 2007) $
***************************************************************************
**/

#include <dlrNumeric/transform2D.h>
#include <dlrTest/testFixture.h>

namespace dlr {

  class Transform2DTest : public TestFixture<Transform2DTest> {

  public:

    Transform2DTest();
    ~Transform2DTest() {};

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    // Tests of member functions.
    void testInvert();

  private:

  }; // class Transform2DTest


  /* ============== Member Function Definititions ============== */

  Transform2DTest::
  Transform2DTest()
    : TestFixture<Transform2DTest>("Transform2DTest")
  {
    // Register all tests.
    DLR_TEST_REGISTER_MEMBER(testInvert);
  }


  void
  Transform2DTest::
  testInvert()
  {
    Transform2D xf0(1.0, 2.0, 3.0,
                    0.0, 4.0, 5.0,
                    1.0, 0.0, 6.0);
    Transform2D xf0Inverse = xf0.invert();
    Transform2D ident = xf0 * xf0Inverse;
    double testEpsilon = 1.0e-12;
    for(size_t rowIndex = 0; rowIndex < 3; ++rowIndex) {
      for(size_t columnIndex = 0; columnIndex < 3; ++columnIndex) {
        if(rowIndex == columnIndex) {
          DLR_TEST_ASSERT(
            approximatelyEqual(
              ident(rowIndex, columnIndex), 1.0, testEpsilon));
        } else {
          DLR_TEST_ASSERT(
            approximatelyEqual(
              ident(rowIndex, columnIndex), 0.0, testEpsilon));
        }
      }
    }
  }

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::Transform2DTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::Transform2DTest currentTest;

}

#endif
