/**
***************************************************************************
* @file dlrUtilities/utilities.h
*
* Header file declaring some 3D geometric utilities for finding
* intersects, etc.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 885 $
* $Date: 2007-05-04 01:01:15 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_GEOMETRY_UTILITIES3D_H_
#define _DLR_GEOMETRY_UTILITIES3D_H_

#include <dlrNumeric/vector3D.h>
#include <dlrGeometry/plane3D.h>
#include <dlrGeometry/ray3D.h>


namespace dlr {

  namespace geometry {


    numeric::Vector3D
    findIntersect(const Ray3D& ray, const Plane3D& plane, double& distance);
    
    
  } // namespace utilities
    
} // namespace dlr


/* ======= Inline and template function definitions. ======= */

namespace dlr {

  namespace geometry {

    
  } // namespace geometry
  
} // namespace dlr


#endif /* #ifndef _DLR_GEOMETRY_UTILITIES3D_H_ */
