/**
***************************************************************************
* @file plane3DTest.cpp
*
* Source file defining tests for the Plane3D class.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 906 $
* $Date: 2007-05-17 15:04:14 -0400 (Thu, 17 May 2007) $
***************************************************************************
**/

#include <dlrCommon/functional.h>
#include <dlrGeometry/plane3D.h>
#include <dlrNumeric/utilities.h>
#include <dlrTest/testFixture.h>


namespace dlr {

  namespace geometry {
    
    class Plane3DTest : public TestFixture<Plane3DTest> {

    public:

      Plane3DTest();
      ~Plane3DTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.
      void testConstructor__iterator__iterator();

    private:

      const double m_defaultTolerance;
      
    }; // class Plane3DTest


    /* ============== Member Function Definititions ============== */

    Plane3DTest::
    Plane3DTest()
      : TestFixture<Plane3DTest>("Plane3DTest"),
        m_defaultTolerance(1.0E-12)
    {
      DLR_TEST_REGISTER_MEMBER(testConstructor__iterator__iterator);
    }


    void
    Plane3DTest::
    testConstructor__iterator__iterator()
    {
      Array1D<Vector3D> pointArray("[Vector3D(-1.0, -1.0, 1.0),"
                                   " Vector3D(-1.0,  0.0, 1.0),"
                                   " Vector3D(-1.0,  1.0, 1.0),"
                                   " Vector3D( 0.0, -1.0, 1.0),"
                                   " Vector3D( 0.0,  0.0, 1.0),"
                                   " Vector3D( 0.0,  1.0, 1.0),"
                                   " Vector3D( 0.0,  1.0, 2.0)," // Outlier.
                                   " Vector3D( 1.0, -1.0, 1.0),"
                                   " Vector3D( 1.0,  0.0, 1.0),"
                                   " Vector3D( 1.0,  1.0, 1.0)]");

      Plane3D plane0(pointArray.begin(), pointArray.end(), 0.9);
      DLR_TEST_ASSERT(
        approximatelyEqual(plane0.getOrigin().z(), 1.0, m_defaultTolerance));
      DLR_TEST_ASSERT(
        approximatelyEqual(plane0.getDirectionVector0().z(), 0.0,
                           m_defaultTolerance));
      DLR_TEST_ASSERT(
        approximatelyEqual(plane0.getDirectionVector1().z(), 0.0,
                           m_defaultTolerance));
      DLR_TEST_ASSERT(
        approximatelyEqual(
          dot(plane0.getDirectionVector0(), plane0.getDirectionVector1()),
          0.0, m_defaultTolerance));
    }
  
  } // namespace geometry

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::geometry::Plane3DTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::geometry::Plane3DTest currentTest;

}

#endif
