/**
***************************************************************************
* @file testImages.h
*
* Header file specifying file names for images to be used in image
* processing tests.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 908 $
* $Date: 2007-05-17 15:08:54 -0400 (Thu, 17 May 2007) $
***************************************************************************
*/

#ifndef _DLRIMAGEPROCESSING_TEST_TESTIMAGES_H_
#define _DLRIMAGEPROCESSING_TEST_TESTIMAGES_H_

#ifndef DLR_TEST_DATA_DIR
#define DLR_TEST_DATA_DIR "."
#endif

#include <string>
#include <dlrUtilities/path.h>

namespace dlr {

  
  inline std::string
  getConnectedComponentsFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "connectedComponentsTestImage0.pgm");
  }


  inline std::string
  getDilateErodeFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "dilateErodeTestImage0.pgm");
  }


  inline std::string
  getDilatedFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "dilatedTestImage0.pgm");
  }


  inline std::string
  getEdgeImageFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "edgeTestImage0.pgm");
  }
  
  
  inline std::string
  getErodedFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "erodedTestImage0.pgm");
  }


  inline std::string
  getTestImageFileNamePGM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePGM0.pgm");
  }


  inline std::string
  getTestImageFileNamePGM1() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePGM1.pgm");
  }
  

  inline std::string
  getTestImageFileNamePGM2() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePGM2.pgm");
  }
  

  inline std::string
  getTestImageFileNamePGM3() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePGM3.pgm");
  }
  
  
  inline std::string
  getTestImageFileNamePPM0() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePPM0.ppm");
  }


  inline std::string
  getTestImageFileNamePPM1() {
    return dlr::utilities::joinPath(
      DLR_TEST_DATA_DIR, "testImagePPM1.ppm");
  }
  
} // namespace dlr

#endif /* #ifndef _DLRIMAGEPROCESSING_TEST_TESTIMAGES_H_ */
