/**
***************************************************************************
* @file imageIOTest.cpp
* Source file defining tests for string manipulation routines.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 906 $
* $Date: 2007-05-17 15:04:14 -0400 (Thu, 17 May 2007) $
***************************************************************************
**/

#include <string>

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrTest/testFixture.h>

// xxx
#include <dlrUtilities/imageIO.h>

namespace dlr {

  namespace computerVision {
    
    class ImageIOTest : public TestFixture<ImageIOTest> {

    public:

      ImageIOTest();
      ~ImageIOTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests of member functions.
      void testReadPGM8();
      void testReadPGM16();
      void testReadPPM8();
      void testWritePGM8();
//     void testFoo();

    private:

    }; // class ImageIOTest


    /* ============== Member Function Definititions ============== */

    ImageIOTest::
    ImageIOTest()
      : TestFixture<ImageIOTest>("ImageIOTest")
    {
      DLR_TEST_REGISTER_MEMBER(testReadPGM8);
      DLR_TEST_REGISTER_MEMBER(testReadPGM16);
      DLR_TEST_REGISTER_MEMBER(testReadPPM8);
      DLR_TEST_REGISTER_MEMBER(testWritePGM8);
//     DLR_TEST_REGISTER_MEMBER(testFoo);
    }


    void
    ImageIOTest::
    testReadPGM8()
    {
      Image<GRAY8> inputImage0 = readPGM8(getTestImageFileNamePGM0());
      Image<GRAY8> inputImage1 = readPGM8(getTestImageFileNamePGM1());
      DLR_TEST_ASSERT(std::equal(inputImage0.begin(), inputImage0.end(),
                                 inputImage1.begin()));
    }


    void
    ImageIOTest::
    testReadPGM16()
    {
      Image<GRAY16> inputImage0 = readPGM16(getTestImageFileNamePGM2());
      Image<GRAY16> inputImage1 = readPGM16(getTestImageFileNamePGM3());
      DLR_TEST_ASSERT(std::equal(inputImage0.begin(), inputImage0.end(),
                                 inputImage1.begin()));
      DLR_TEST_ASSERT(std::equal(inputImage0.begin(), inputImage0.end(),
                                 inputImage1.begin()));
    }


    void
    ImageIOTest::
    testReadPPM8()
    {
      Image<RGB8> inputImage1 = readPPM8(getTestImageFileNamePPM1());
      Image<RGB8> inputImage0 = readPPM8(getTestImageFileNamePPM0());
      DLR_TEST_ASSERT(std::equal(inputImage0.begin(), inputImage0.end(),
                                 inputImage1.begin()));
    }


//   void
//   ImageIOTest::
//   testFoo()
//   {
//     Image<GRAY16> inputImage0 = readPGM16("magicSpliceBin.pgm");
//     writePGM("dlrSpliceAsciiFromMagicBin.pgm", inputImage0.data(),
//              inputImage0.rows(), inputImage0.columns(),
//              false, false, 16);
//     writePGM("dlrSpliceBinFromMagicBin.pgm", inputImage0.data(),
//              inputImage0.rows(), inputImage0.columns(),
//              false, true, 16);
//   }
    

    void
    ImageIOTest::
    testWritePGM8()
    {
      // Empty.
    }

  } // namespace computerVision

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::computerVision::ImageIOTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::computerVision::ImageIOTest currentTest;

}

#endif
