/**
***************************************************************************
* @file dilateTest.cpp
*
* Source file defining tests for dilate().
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/dilate.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrTest/testFixture.h>


namespace dlr {

  namespace computerVision {
    
    class DilateTest
      : public TestFixture<DilateTest> {

    public:

      DilateTest();
      ~DilateTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.
      void testDilate();

    private:

    }; // class DilateTest


    /* ============== Member Function Definititions ============== */

    DilateTest::
    DilateTest()
      : TestFixture<DilateTest>("DilateTest")
    {
      DLR_TEST_REGISTER_MEMBER(testDilate);
    }


    void
    DilateTest::
    testDilate()
    {
      Image<GRAY8> inputImage = readPGM8(getDilateErodeFileNamePGM0());
      Image<GRAY8> referenceImage = readPGM8(getDilatedFileNamePGM0());
      Image<GRAY8> dilatedImage = dilate<GRAY8>(inputImage) * UnsignedInt8(255);
      DLR_TEST_ASSERT(dilatedImage.rows() == referenceImage.rows());
      DLR_TEST_ASSERT(dilatedImage.columns() == referenceImage.columns());
      for(size_t index0 = 0; index0 < inputImage.size(); ++index0) {
        DLR_TEST_ASSERT(dilatedImage[index0] == referenceImage[index0]);
      }
    }

  } // namespace computerVision

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::computerVision::DilateTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::computerVision::DilateTest currentTest;

}

#endif
