/**
***************************************************************************
* @file connectedComponentsTest.cpp
*
* Source file defining tests for connectedComponents().
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/connectedComponents.h>
#include <dlrComputerVision/imageIO.h>
#include <dlrTest/testFixture.h>

namespace dlr {

  namespace computerVision {

    class ConnectedComponentsTest
      : public TestFixture<ConnectedComponentsTest> {

    public:

      ConnectedComponentsTest();
      ~ConnectedComponentsTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.
      void testConnectedComponents();

    private:

    }; // class ConnectedComponentsTest


    /* ============== Member Function Definititions ============== */

    ConnectedComponentsTest::
    ConnectedComponentsTest()
      : TestFixture<ConnectedComponentsTest>("ConnectedComponentsTest")
    {
      DLR_TEST_REGISTER_MEMBER(testConnectedComponents);
    }


    void
    ConnectedComponentsTest::
    testConnectedComponents()
    {
      Image<GRAY8> inputImage = readPGM8(getConnectedComponentsFileNamePGM0());
      Image<GRAY8> binaryImage(inputImage.rows(), inputImage.columns());
      for(size_t index0 = 0; index0 < inputImage.size(); ++index0) {
        if(inputImage[index0] == 0) {
          binaryImage[index0] = UnsignedInt8(0);
        } else {
          binaryImage[index0] = UnsignedInt8(1);
        }
      }
      Image<GRAY8> ccImage = connectedComponents<GRAY8>(binaryImage);
      for(size_t index0 = 0; index0 < inputImage.size(); ++index0) {
        DLR_TEST_ASSERT(ccImage[index0] == inputImage[index0]);
      }
    }

  } // namespace computerVision

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::computerVision::ConnectedComponentsTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::computerVision::ConnectedComponentsTest currentTest;

}

#endif
