/**
***************************************************************************
* @file dlrComputerVision/erode.h
*
* Header file declaring the erode() function template.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_ERODE_H_
#define _DLRCOMPUTERVISION_ERODE_H_

#include <dlrComputerVision/image.h>

namespace dlr {

  namespace computerVision {
  
    template<ImageFormat FORMAT>
    Image<FORMAT>
    erode(const Image<FORMAT>& inputImage);

  } // namespace computerVision
    
} // namespace dlr


/* ============ Definitions of inline & template functions ============ */


#include <cmath>

namespace dlr {

  namespace computerVision {
  
    template<ImageFormat FORMAT>
    Image<FORMAT>
    erode(const Image<FORMAT>& inputImage)
    {
      typedef typename Image<FORMAT>::value_type ValueType;
    
      Image<FORMAT> outputImage(inputImage.rows(), inputImage.columns());

      size_t index0 = 0;
      size_t row = 0;
      size_t rowBoundary0 = 1;
      size_t rowBoundary1 = inputImage.rows() - 1;
      for(; row < rowBoundary0; ++row) {
        for(size_t column = 0; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }


      size_t colBoundary0 = 1;
      size_t colBoundary1 = inputImage.columns() - 1;
      for(; row < rowBoundary1; ++row) {
        size_t column = 0;
        for(; column < colBoundary0; ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }        
        for(; column < colBoundary1; ++column) {
          if(inputImage[index0 - 1]
             && inputImage[index0 + 1]
             && inputImage[index0 - inputImage.columns() - 1]
             && inputImage[index0 - inputImage.columns()]
             && inputImage[index0 - inputImage.columns() + 1]
             && inputImage[index0 + inputImage.columns() - 1]
             && inputImage[index0 + inputImage.columns()]
             && inputImage[index0 + inputImage.columns() + 1]) {
            outputImage[index0] = inputImage[index0];
          } else {
            outputImage[index0] = ValueType(0);
          }
          ++index0;
        }
        for(; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }

      for(; row < inputImage.rows(); ++row) {
        for(size_t column = 0; column < inputImage.columns(); ++column) {
          outputImage[index0] = ValueType(0);
          ++index0;
        }
      }      

      return outputImage;
    }

  } // namespace computerVision
    
} // namespace dlr

#endif /* #ifndef _DLRCOMPUTERVISION_ERODE_H_ */
