/**
***************************************************************************
* @file dlrTest/autoregister.cpp
*
* Source file allowing control of what gets run by the main() routine
* in libdlrTestAutomaticMain.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#ifndef DLR_TEST_USE_AUTOMATIC_MAIN
#define DLR_TEST_USE_AUTOMATIC_MAIN
#endif

#include <dlrTest/autoregister.h>
#include <dlrTest/runnableObject.h>

namespace dlr {

  namespace test {

    /// @cond privateCode
    namespace privateCode {

      std::set<RunnableObject*>&
      getGlobalTestSet() {
	static std::set<RunnableObject*> globalTestSet;
	return globalTestSet;
      }
      
    }
    /// @endcond


    // Schedule a TestFixture to be run automatically.
    void
    private_registerTestFixture(RunnableObject& testFixture)
    {
      (privateCode::getGlobalTestSet()).insert(&testFixture);
    }


    // Un-schedule a TestFixture so that it will no longer be run
    // automatically.
    void
    private_unregisterTestFixture(RunnableObject& testFixture)
    {
      (privateCode::getGlobalTestSet()).erase(&testFixture);
    }

  }
}
