/**
***************************************************************************
* @file testAutoMain.cpp
*
* Source file a main() routine to be used in unit testing.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#include <dlrTest/autoregister.h>
#include <dlrTest/runnableObject.h>

namespace dlr {

  namespace test {

    /// @cond privateCode
    namespace privateCode {

      // defined in autoregister.cpp
      std::set<RunnableObject*>&
      getGlobalTestSet();
      
    }
    /// @endcond

  }
}

using namespace dlr::test;

int main(int argc, char** argv)
{
  bool aggregateResult = true;
  typedef std::set<RunnableObject*>::iterator TestFixtureIterator;
  std::set<RunnableObject*>& globalTestSet = privateCode::getGlobalTestSet();
  for(TestFixtureIterator iter = globalTestSet.begin();
      iter != globalTestSet.end();
      ++iter) {
    bool testResult = (*iter)->run();
    aggregateResult &= testResult;
  }
  return (aggregateResult ? 0 : 1);
}
