/**
***************************************************************************
* @file rotationsTest.cpp
* 
* Source file defining rotationsTest class.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 939 $
* $Date: 2007-06-09 13:08:18 -0400 (Sat, 09 Jun 2007) $
***************************************************************************
**/

#include <dlrNumeric/rotations.h>

#include <dlrTest/testFixture.h>

namespace dlr {

  class RotationsTest : public TestFixture<RotationsTest> {

  public:

    RotationsTest();
    ~RotationsTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    void testAxisAngleToQuaternion();
    void testAxisAngleToRollPitchYaw();
    void testAxisAngleToTransform3D();

    void testQuaternionToAxisAngle();
    void testQuaternionToRollPitchYaw();
    void testQuaternionToTransform3D();

    void testRollPitchYawToAxisAngle();
    void testRollPitchYawToQuaternion();
    void testRollPitchYawToTransform3D();

    void testTransform3DToAxisAngle();
    void testTransform3DToQuaternion();
    void testTransform3DToRollPitchYaw();

  private:
    
  }; // class RotationsTest


  /* ============== Member Function Definititions ============== */

  RotationsTest::
  RotationsTest()
    : TestFixture<RotationsTest>("RotationsTest")
  {
    // Register all tests.
    DLR_TEST_REGISTER_MEMBER(testAxisAngleToQuaternion);
    DLR_TEST_REGISTER_MEMBER(testAxisAngleToRollPitchYaw);
    DLR_TEST_REGISTER_MEMBER(testAxisAngleToTransform3D);

    DLR_TEST_REGISTER_MEMBER(testQuaternionToAxisAngle);
    DLR_TEST_REGISTER_MEMBER(testQuaternionToRollPitchYaw);
    DLR_TEST_REGISTER_MEMBER(testQuaternionToTransform3D);

    DLR_TEST_REGISTER_MEMBER(testRollPitchYawToAxisAngle);
    DLR_TEST_REGISTER_MEMBER(testRollPitchYawToQuaternion);
    DLR_TEST_REGISTER_MEMBER(testRollPitchYawToTransform3D);

    DLR_TEST_REGISTER_MEMBER(testTransform3DToAxisAngle);
    DLR_TEST_REGISTER_MEMBER(testTransform3DToQuaternion);
    DLR_TEST_REGISTER_MEMBER(testTransform3DToRollPitchYaw);
  }


  void
  RotationsTest::
  testAxisAngleToQuaternion()
  {
    
  }

  
  void
  RotationsTest::
  testAxisAngleToRollPitchYaw()
  {

  }

  
  void
  RotationsTest::
  testAxisAngleToTransform3D()
  {

  }

  
  void
  RotationsTest::
  testQuaternionToAxisAngle()
  {

  }

  
  void
  RotationsTest::
  testQuaternionToRollPitchYaw()
  {

  }

  
  void
  RotationsTest::
  testQuaternionToTransform3D()
  {

  }

  
  void
  RotationsTest::
  testRollPitchYawToAxisAngle()
  {

  }

  
  void
  RotationsTest::
  testRollPitchYawToQuaternion()
  {

  }

  
  void
  RotationsTest::
  testRollPitchYawToTransform3D()
  {

  }

  
  void
  RotationsTest::
  testTransform3DToAxisAngle()
  {

  }

  
  void
  RotationsTest::
  testTransform3DToQuaternion()
  {

  }

  
  void
  RotationsTest::
  testTransform3DToRollPitchYaw()
  {

  }
  

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::RotationsTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::RotationsTest currentTest;

}

#endif
