/**
***************************************************************************
* @file geometry2DTest.cpp
* 
* Source file defining geometry2DTest class.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#include <dlrNumeric/geometry2D.h>
#include <dlrNumeric/utilities.h>
#include <dlrTest/testFixture.h>

namespace dlr {

  class Geometry2DTest : public TestFixture<Geometry2DTest> {

  public:

    Geometry2DTest();
    ~Geometry2DTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    void testBilaterate();

  private:

    const double m_defaultTolerance;
    
  }; // class Geometry2DTest


  /* ============== Member Function Definititions ============== */

  Geometry2DTest::
  Geometry2DTest()
    : TestFixture<Geometry2DTest>("Geometry2DTest"),
      m_defaultTolerance(1.0E-6)
  {
    // Register all tests.
    DLR_TEST_REGISTER_MEMBER(testBilaterate);
  }


  void
  Geometry2DTest::
  testBilaterate()
  {
    for(double x0 = -2.0; x0 < 2.5; x0 += 1.0) {
      for(double y0 = -2.0; y0 < 2.5; y0 += 1.0) {
        for(double x1 = -2.0; x1 < 2.5; x1 += 1.0) {
          for(double y1 = 7.0; y1 < 11.5; y1 += 1.0) {
            for(double x2 = 7.0; x2 < 11.5; x2 += 1.0) {
              for(double y2 = -2.0; y2 < 2.5; y2 += 1.0) {
                Vector2D center0(x0, y0);
                Vector2D center1(x1, y1);
                Vector2D target(x2, y2);
                double r0 = magnitude(target - center0);
                double r1 = magnitude(target - center1);
                Vector2D recoveredPoint0;
                Vector2D recoveredPoint1;
                
//                 DLR_TEST_ASSERT(
//                   bilaterate(center0, center1, r0, r1,
//                              recoveredPoint0, recoveredPoint1)
//                   == true);
                bool result = bilaterate(center0, center1, r0, r1,
                                         recoveredPoint0, recoveredPoint1);
                if(!result) {
                  DLR_TEST_ASSERT(false);
                }

                double distance0 = magnitude(recoveredPoint0 - target);
                double distance1 = magnitude(recoveredPoint1 - target);
//                 DLR_TEST_ASSERT((distance0 < m_defaultTolerance)
//                                 || (distance1 < m_defaultTolerance));
                bool result2 = ((distance0 < m_defaultTolerance)
                                || (distance1 < m_defaultTolerance));
                if(!result2) {
                  DLR_TEST_ASSERT(false);
                }
              }
            }
          }
        }
      }
    }
  }

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::Geometry2DTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::Geometry2DTest currentTest;

}

#endif
