/**
***************************************************************************
* @file utilities3DTest.cpp
*
* Source file defining tests for dlrGeometry library utilities.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 906 $
* $Date: 2007-05-17 15:04:14 -0400 (Thu, 17 May 2007) $
***************************************************************************
**/

#include <dlrCommon/functional.h>
#include <dlrGeometry/utilities3D.h>
#include <dlrNumeric/utilities.h>
#include <dlrTest/testFixture.h>


namespace dlr {

  namespace geometry {
    
    class Utilities3DTest : public TestFixture<Utilities3DTest> {

    public:

      Utilities3DTest();
      ~Utilities3DTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.
      void testFindIntersect__ray__plane__doubleRef();

    private:

      const double m_defaultTolerance;
      
    }; // class Utilities3DTest


    /* ============== Member Function Definititions ============== */

    Utilities3DTest::
    Utilities3DTest()
      : TestFixture<Utilities3DTest>("Utilities3DTest"),
        m_defaultTolerance(1.0E-12)
    {
      DLR_TEST_REGISTER_MEMBER(testFindIntersect__ray__plane__doubleRef);
    }


    void
    Utilities3DTest::
    testFindIntersect__ray__plane__doubleRef()
    {
      Plane3D plane0(Vector3D(1.0, 0.0, 1.0),
                     Vector3D(1.0, 1.0, 1.0),
                     Vector3D(0.0, 0.0, 1.0));
      Ray3D ray0(Vector3D(4.0, 2.0, 10.0), Vector3D(0.0, 0.0, -1.0));
      Ray3D ray1(Vector3D(8.0, 33.0, 13.0), Vector3D(-1.0, -5.0, -2.0));

      double distance0;
      double distance1;
      Vector3D point0 = findIntersect(ray0, plane0, distance0);
      Vector3D point1 = findIntersect(ray1, plane0, distance1);

      Vector3D referencePoint0(4.0, 2.0, 1.0);
      Vector3D referencePoint1(2.0, 3.0, 1.0);
      double referenceDistance0 =
        magnitude(ray0.getOrigin() - referencePoint0);
      double referenceDistance1 =
        magnitude(ray1.getOrigin() - referencePoint1);
      
      DLR_TEST_ASSERT(approximatelyEqual(point0.x(), referencePoint0.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(point0.x(), referencePoint0.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(point0.x(), referencePoint0.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(distance0, referenceDistance0,
                                         m_defaultTolerance));

      DLR_TEST_ASSERT(approximatelyEqual(point1.x(), referencePoint1.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(point1.x(), referencePoint1.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(point1.x(), referencePoint1.x(),
                                         m_defaultTolerance));
      DLR_TEST_ASSERT(approximatelyEqual(distance1, referenceDistance1,
                                         m_defaultTolerance));
    }
  
  } // namespace geometry

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::geometry::Utilities3DTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::geometry::Utilities3DTest currentTest;

}

#endif
