/**
***************************************************************************
* @file sobelTest.cpp
*
* Source file defining tests for routines defined in
* dlrComputerVision/sobel.h.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/sobel.h>
#include <dlrTest/testFixture.h>

using namespace dlr::computerVision;

namespace dlr {

  class SobelTest
    : public TestFixture<SobelTest> {

  public:

    SobelTest();
    ~SobelTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    // Tests.
    void testSobelX();
    void testSobelY();

  private:

  }; // class SobelTest


  /* ============== Member Function Definititions ============== */

  SobelTest::
  SobelTest()
    : TestFixture<SobelTest>("SobelTest")
  {
    DLR_TEST_REGISTER_MEMBER(testSobelX);
    DLR_TEST_REGISTER_MEMBER(testSobelY);
  }


  void
  SobelTest::
  testSobelX()
  {
    Array2D<Int32> inputArray("[[ 0,  1,  0, -2],"
                              " [ 7,  5,  2,  3],"
                              " [10,  9,  8,  7],"
                              " [ 3,  2,  3,  4],"
                              " [ 2,  2,  5,  9]]");

    Array2D<Int32> referenceArray("[[  8,   0, -12, -16],"
                                  " [ -8, -12,  -9,  -2],"
                                  " [-10,  -9,  -4,   0],"
                                  " [ -6,   1,   9,  10],"
                                  " [  0,  12,  28,  32]]");
    
    Image<GRAY_SIGNED32> inputImage = inputArray;
    Image<GRAY_SIGNED32> resultImage = applySobelX(inputImage);

    DLR_TEST_ASSERT(resultImage.rows() == referenceArray.rows());
    DLR_TEST_ASSERT(resultImage.columns() == referenceArray.columns());
    for(size_t index0 = 0; index0 < resultImage.size(); ++index0) {
      DLR_TEST_ASSERT(resultImage[index0] == referenceArray[index0]);
    }
  }


  void
  SobelTest::
  testSobelY()
  {
    Array2D<Int32> inputArray("[[ 0,  1,  0, -2],"
                              " [ 7,  5,  2,  3],"
                              " [10,  9,  8,  7],"
                              " [ 3,  2,  3,  4],"
                              " [ 2,  2,  5,  9]]");

    Array2D<Int32> referenceArray("[[ 56, 34,  26,  40],"
                                  " [ 40, 34,  33,  36],"
                                  " [-16, -9,   0,   4],"
                                  " [-32,-25, -11,   8],"
                                  " [ -8,  2,  18,  40]]");
    
    Image<GRAY_SIGNED32> inputImage = inputArray;
    Image<GRAY_SIGNED32> resultImage = applySobelY(inputImage);

    DLR_TEST_ASSERT(resultImage.rows() == referenceArray.rows());
    DLR_TEST_ASSERT(resultImage.columns() == referenceArray.columns());
    for(size_t index0 = 0; index0 < resultImage.size(); ++index0) {
      DLR_TEST_ASSERT(resultImage[index0] == referenceArray[index0]);
    }
  }

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::SobelTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::SobelTest currentTest;

}

#endif
