/**
***************************************************************************
* @file nonMaximumSuppressTest.cpp
*
* Source file defining tests for routines defined in
* dlrComputerVision/nonMaximumSuppress.h.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: $
* $Date: $
***************************************************************************
**/

#include <dlrComputerVision/test/testImages.h>
#include <dlrComputerVision/nonMaximumSuppress.h>
#include <dlrTest/testFixture.h>

using namespace dlr::computerVision;

namespace dlr {

  class NonMaximumSuppressTest
    : public TestFixture<NonMaximumSuppressTest> {

  public:

    NonMaximumSuppressTest();
    ~NonMaximumSuppressTest() {}

    void setUp(const std::string& testName) {}
    void tearDown(const std::string& testName) {}

    // Tests.
    void testNonMaximumSuppress();

  private:

  }; // class NonMaximumSuppressTest


  /* ============== Member Function Definititions ============== */

  NonMaximumSuppressTest::
  NonMaximumSuppressTest()
    : TestFixture<NonMaximumSuppressTest>("NonMaximumSuppressTest")
  {
    DLR_TEST_REGISTER_MEMBER(testNonMaximumSuppress);
  }


  void
  NonMaximumSuppressTest::
  testNonMaximumSuppress()
  {
    Array2D<Int32> inputArray("[[ 0,  1,  0, -2, 5],"
                              " [ 7,  5,  2,  3, 2],"
                              " [ 8,  9,  8,  7, 6],"
                              " [ 1, 10,  3,  4, 8],"
                              " [ 2,  2,  5,  9, 2],"
                              " [ 5,  4,  0,  6, 3],"
                              " [ 1,  3,  5,  4, 3]]");


    Array2D<Float64> gradXArray("[[ 1.0,  1.5,  1.7,  0.0, 1.0],"
                                " [ 3.2,  0.0,  2.5,  6.1, 2.0],"
                                " [-1.0,  9.0,  4.0,  1.2, 1.5],"
                                " [-6.0,  1.5, -2.9, -6.0, 0.9],"
                                " [-6.0, -1.9, -7.9, -5.0, 0.9],"
                                " [-6.0, -0.7, -7.9,  4.0, 0.9],"
                                " [   0,  1.2,  2.8,  3.2, 1.2]]");

    Array2D<Float64> gradYArray("[[ 8.0,  0.0, -1.2,  -1.6,  1.2],"
                                " [-1.8,  0.0,  0.9,   2.0, -1.0],"
                                " [-1.0, -0.9, -1.4,  -0.7,  4.4],"
                                " [ 2.6, -3.1, -9.3, -10.0, -2.1],"
                                " [ 0.0, -2.0, -3.8,   1.0,  2.3],"
                                " [ 0.0,  1.9, -3.8,   5.3,  2.3],"
                                " [ 2.0,  2.5,  1.8,  -3.3,  1.0]]");

    Array2D<Float64> referenceArray("[[  0,   0,  0,  0,  0],"
                                    " [  0,   0,  0,  3,  0],"
                                    " [  0,   9,  0,  7,  0],"
                                    " [  0,  10,  0,  0,  0],"
                                    " [  0,   2,  0,  9,  0],"
                                    " [  0,   4,  0,  6,  0],"
                                    " [  0,   0,  0,  0,  0]]");
    
    Image<GRAY_SIGNED32> inputImage = inputArray;
    Image<GRAY_FLOAT64> gradX = gradXArray;
    Image<GRAY_FLOAT64> gradY = gradYArray;
    Image<GRAY_SIGNED32> resultImage =
      nonMaximumSuppress(inputImage, gradX, gradY);

    DLR_TEST_ASSERT(resultImage.rows() == referenceArray.rows());
    DLR_TEST_ASSERT(resultImage.columns() == referenceArray.columns());
    for(size_t index0 = 0; index0 < resultImage.size(); ++index0) {
      DLR_TEST_ASSERT(resultImage[index0] == referenceArray[index0]);
    }
  }

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::NonMaximumSuppressTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::NonMaximumSuppressTest currentTest;

}

#endif
