/**
***************************************************************************
* @file dlrComputerVision/imageIO.h
*
* Header file declaring functions for reading and writing images.
*
* Copyright (C) 2005-2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 878 $
* $Date: 2007-05-04 00:17:41 -0400 (Fri, 04 May 2007) $
***************************************************************************
*/

#ifndef _DLRCOMPUTERVISION_IMAGEIO_H_
#define _DLRCOMPUTERVISION_IMAGEIO_H_


#include <string>
#include <dlrComputerVision/image.h>

namespace dlr {

  namespace computerVision {
  
    Image<GRAY8>
    readPGM8(const std::string& fileName);

  
    Image<GRAY8>
    readPGM8(const std::string& fileName, std::string& commentString);

  
    Image<GRAY16>
    readPGM16(const std::string& fileName);

  
    Image<RGB8>
    readPPM8(const std::string& fileName);

  
    void
    writePGM8(const std::string& fileName,
              const Image<GRAY8>& outputImage,
              const std::string& comment = "");
  
  
    void
    writePGM16(const std::string& fileName,
               const Image<GRAY16>& outputImage,
               const std::string& comment = "");
  

    void
    writePPM8(const std::string& fileName,
              const Image<RGB8>& outputImage,
              const std::string& comment = "");
    
  } // namespace computerVision

} // namespace dlr


#endif /* #ifndef _DLRCOMPUTERVISION_IMAGEIO_H_ */
