/**
***************************************************************************
* @file dlrCommon/compileTimestamp.cpp
* Source file defining CompileTimestamp class.
*
* Copyright (C) 2006-2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 877 $
* $Date: 2007-05-04 00:12:02 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#include <iomanip>
#include <sstream>
#include <dlrCommon/compileTimestamp.h>
#include <dlrCommon/exception.h>
#include <dlrCommon/inputStream.h>

namespace dlr {

  namespace common {

    std::string
    CompileTimestamp::
    getISOString()
    {
      std::ostringstream isoStream;
      isoStream << std::setfill('0')
		<< std::setw(4) << m_year << "-"
		<< std::setw(2) << m_month + 1 << "-"
		<< std::setw(2) << m_day + 1 << " "
		<< std::setw(2) << m_hour << ":"
		<< std::setw(2) << m_minute << ":"
		<< std::setw(2) << m_second;
      return isoStream.str();
    }
    

    void
    CompileTimestamp::
    parseCompilerDateString(const std::string& compilerDateString)
    {
      std::istringstream compilerDateStream(compilerDateString);

      std::string monthString;
      compilerDateStream >> monthString;
      if(monthString == "Jan") {m_month = 0;}
      else if(monthString == "Feb") {m_month = 1;}
      else if(monthString == "Mar") {m_month = 2;}
      else if(monthString == "Apr") {m_month = 3;}
      else if(monthString == "May") {m_month = 4;}
      else if(monthString == "Jun") {m_month = 5;}
      else if(monthString == "Jul") {m_month = 6;}
      else if(monthString == "Aug") {m_month = 7;}
      else if(monthString == "Sep") {m_month = 8;}
      else if(monthString == "Oct") {m_month = 9;}
      else if(monthString == "Nov") {m_month = 10;}
      else if(monthString == "Dec") {m_month = 11;}
      else {
	std::ostringstream message;
	message << "Unable to recover month from date string \""
		<< compilerDateString << "\".";
	DLR_THROW(ValueException,
		  "CompileTimestamp::parseCompilerDateString()",
		  message.str().c_str());
      }

      compilerDateStream >> m_day;
      --m_day;

      compilerDateStream >> m_year;

      if(!compilerDateStream) {
	std::ostringstream message;
	message << "Unable to parse date string \"" << compilerDateString
		<< "\".";
	DLR_THROW(ValueException,
		  "CompileTimestamp::parseCompilerDateString()",
		  message.str().c_str());
      }
    }

  
    void
    CompileTimestamp::
    parseCompilerTimeString(const std::string& compilerTimeString)
    {
      std::istringstream compilerTimeStream(compilerTimeString);
      InputStream dlrStream(compilerTimeStream);
      compilerTimeStream >> m_hour;
      dlrStream.expect(":");
      compilerTimeStream >> m_minute;
      dlrStream.expect(":");
      compilerTimeStream >> m_second;
      if(!compilerTimeStream) {
	std::ostringstream message;
	message << "Unable to parse time string \"" << compilerTimeString
		<< "\".";
	DLR_THROW(ValueException,
		  "CompileTimestamp::parseCompilerTimeString()",
		  message.str().c_str());
      }
    }
  
  } // namespace common

} // namespace dlr
