/**
***************************************************************************
* @file timeUtilitiesTest.cpp
*
* Source file defining TimeUtilitiesTest class.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 795 $
* $Date: 2006-10-20 19:01:27 -0400 (Fri, 20 Oct 2006) $
***************************************************************************
**/

#include <dlrUtilities/timeUtilities.h>
#include <dlrTest/testFixture.h>


namespace dlr {

  namespace utilities {

    class TimeUtilitiesTest
      : public TestFixture<TimeUtilitiesTest>
    {
    public:

      typedef TimeUtilitiesTest TestFixtureType;
    

      TimeUtilitiesTest();
      ~TimeUtilitiesTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      void testGetCurrentTime();

    private:

    
    }; // class TimeUtilitiesTest


    /* ============== Member Function Definititions ============== */

    TimeUtilitiesTest::
    TimeUtilitiesTest()
      : TestFixture<TimeUtilitiesTest>("TimeUtilitiesTest")
    {
      // Register all tests.
      DLR_TEST_REGISTER_MEMBER(testGetCurrentTime);
    }


    void
    TimeUtilitiesTest::
    testGetCurrentTime()
    {
      // Make sure time resolution is better than 1ms.  On a typical
      // LINUX box you can change this to a number as small as
      // 0.00001 (10 microseconds) and still pass the test.
      const double requiredClockResolution = 0.001;
      const double testDuration = 1.0;

      double previousTime = getCurrentTime();
      double endTime = previousTime + testDuration;
      double updateAccumulator = 0.0;
      unsigned int numberOfUpdates = 0;
      double currentTime = 0;
      while(currentTime < endTime) {
        currentTime = getCurrentTime();
        DLR_TEST_ASSERT(currentTime >= previousTime);
        if(currentTime > previousTime) {
          double difference = currentTime - previousTime;
          updateAccumulator += difference;
          ++numberOfUpdates;
          previousTime = currentTime;
        }
      }
      DLR_TEST_ASSERT(numberOfUpdates != 0);
      double averageUpdateTime = updateAccumulator / numberOfUpdates;
      DLR_TEST_ASSERT(averageUpdateTime < requiredClockResolution);
    }

  } // namespace utilities
  
} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::utilities::TimeUtilitiesTest currentTest;
  return currentTest.run();
}

#else

namespace {

  dlr::utilities::TimeUtilitiesTest currentTest;
  
}

#endif
