/**
***************************************************************************
* @file dlrUtilities/optionDescription.h
*
* Header file declaring the OptionDescription class.
*
* Copyright (C) 2006 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#ifndef _DLRUTILITIES_OPTIONDESCRIPTION_H_
#define _DLRUTILITIES_OPTIONDESCRIPTION_H_

#include <ostream>
#include <string>

namespace dlr {

  namespace utilities {
    
    /**
     ** The OptionDescription class
     **/
    class OptionDescription {
    public:

      /** 
       * Default constructor.
       */
      OptionDescription();

      
      /** 
       * Constructor.
       */
      OptionDescription(const std::string& name,
                        const std::string& shortAppearance,
                        const std::string& longAppearance,
                        bool requiresValue,
                        bool allowPartialMatch,
                        const std::string& docString,
                        const std::string& defaultValue = "");

      
      /**
       * Destructor.
       */
      ~OptionDescription();


      const std::string&
      getDefaultValue() const {return m_defaultValue;}

      
      const std::string&
      getName() const {return m_name;}


      size_t
      getMatchLength(const std::string& argument,
                     bool& isShortMatch) const;

      
      std::string
      getOptionDoc() const;
      

      bool
      isMatch(const std::string& argument) const;
      
      
      bool
      requiresValue() const {return m_requiresValue;}

    private:

      std::string m_name;
      std::string m_shortAppearance;
      std::string m_longAppearance;
      bool m_requiresValue;
      bool m_allowPartialMatch;
      std::string m_docString;
      std::string m_defaultValue;
    };


    std::ostream&
    operator<<(std::ostream& stream,
               const OptionDescription& optionDescription);

    
  } // namespace utilities

} // namespace dlr

#endif // #ifndef _DLRUTILITES_OPTIONDESCRIPTION_H_
