/**
***************************************************************************
* @file dlrUtilities/timeUtilities.h
*
* Header file declaring some useful time-related routines.
*
* (C) Copyright 2004-2006 David LaRose, dlr@alumni.carnegiemellon.edu
* See accompanying LICENSE file for details.
*
* $Revision: 706 $
* $Date: 2006-08-04 19:41:11 -0400 (Fri, 04 Aug 2006) $
***************************************************************************
**/

#ifndef _DLRUTILITIES_TIMEUTILITIES_H_
#define _DLRUTILITIES_TIMEUTILITIES_H_

#include <dlrPortability/timeUtilities.h>

namespace dlr {

  namespace utilities {
    
    /** 
     * This function returns the current time as a double, the number of
     * seconds since some significant (and OS dependent) event in the
     * distant past.
     */
    using portability::getCurrentTime;

    
    /** 
     * This function causes the program to suspend execution for at
     * least as many seconds as specified by its argument.  The
     * resolution of the timer is implimentation dependent, will
     * always be some small fraction of a second.
     */
    using portability::portableSleep;

  } // namespace utilities
  
} // namespace dlr


/* ======= Declarations to maintain compatibility with legacy code. ======= */

namespace dlr {

  using utilities::getCurrentTime;
  using utilities::portableSleep;
  
} // namespace dlr

#endif // #ifndef _DLRUTILITIES_TIMEUTILITIES_H_
