/**
***************************************************************************
* @file dlrThread/exception.h
*
* Header file declaring some exception types and providing namespace
* documentation.
*
* Copyright (c) 2003-2007, David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
**/

#ifndef _DLR_THREAD_EXCEPTION_H_
#define _DLR_THREAD_EXCEPTION_H_

#include <dlrCommon/exception.h>

namespace dlr {

  /**
   ** This namespace provides some high level multi-threaded
   ** programming abstractions such as shared FIFOs and monitor
   ** objects so that the user doesn't have to think at the level of
   ** locks and mutexes.
   **/
  namespace thread {
  
    /**
     ** This Exception class is thrown when a DataQueue consumer falls
     ** too far behind the head of the queue, causing the queue to
     ** "overflow."
     **/
    class OverflowException : public Exception {
    public:
      OverflowException() throw()
        : Exception("", "OverflowException") {}

      OverflowException(const char* message) throw()
        : Exception(message, "OverflowException") {}

      OverflowException(const char* message, const char* fileName,
                        int lineNumber) throw()
        : Exception(message, "OverflowException", 0, fileName, lineNumber) {}

      OverflowException(const char* message, const char* functionName,
                        const char* fileName, int lineNumber) throw()
        : Exception(message, "OverflowException", functionName, fileName,
                    lineNumber) {}

      OverflowException(const OverflowException& source) throw()
        : Exception(source) {}

      virtual ~OverflowException() throw() {}
    };


    /**
     ** This Exception class can be used by client code to communicate
     ** unexpected synchronization events, such as failure to
     ** synchronize, or receipt of inconsistent data via DataQueue.
     **/
    class SyncException : public Exception {
    public:
      SyncException() throw()
        : Exception("", "SyncException") {}

      SyncException(const char* message) throw()
        : Exception(message, "SyncException") {}

      SyncException(const char* message, const char* fileName,
                        int lineNumber) throw()
        : Exception(message, "SyncException", 0, fileName, lineNumber) {}

      SyncException(const char* message, const char* functionName,
                        const char* fileName, int lineNumber) throw()
        : Exception(message, "SyncException", functionName, fileName,
                    lineNumber) {}

      SyncException(const SyncException& source) throw()
        : Exception(source) {}

      virtual ~SyncException() throw() {}
    };


    
    /**
     ** This Exception class can be used by client code to communicate
     ** that a timeout expired.
     **/
    class TimeoutException : public Exception {
    public:
      TimeoutException() throw()
        : Exception("", "TimeoutException") {}

      TimeoutException(const char* message) throw()
        : Exception(message, "TimeoutException") {}

      TimeoutException(const char* message, const char* fileName,
                        int lineNumber) throw()
        : Exception(message, "TimeoutException", 0, fileName, lineNumber) {}

      TimeoutException(const char* message, const char* functionName,
                        const char* fileName, int lineNumber) throw()
        : Exception(message, "TimeoutException", functionName, fileName,
                    lineNumber) {}

      TimeoutException(const TimeoutException& source) throw()
        : Exception(source) {}

      virtual ~TimeoutException() throw() {}
    };
    
  } // namespace thread

} // namespace dlr

#endif // #ifndef _DLR_THREAD_EXCEPTION_H_
