dnl
dnl DLR_HAVE_DLRUTILITIES()
dnl
dnl Call this autoconf macro to check whether the dlrUtilities library
dnl development files are installed.

AC_DEFUN([DLR_HAVE_DLRUTILITIES],
    [DLR_SAVED_CPPFLAGS="${CPPFLAGS}"
     CPPFLAGS="${CPPFLAGS} -I${includedir} -I${prefix}/include"
     AC_CHECK_HEADER(dlrUtilities/timeUtilities.h, 
         [],
         [AC_MSG_ERROR([Unable to find dlrUtilities/timeUtilities.h.  Please
              check that the dlrUtilities utility library is installed.
              If it is, and this test still fails, try modifying the CPPFLAGS
              environment variable so that the compiler can more easily find
              this include file.])])
     AC_MSG_CHECKING([for -ldlrUtilities])
     DLR_SAVED_LDFLAGS="${LDFLAGS}"
     DLR_SAVED_LIBS="${LIBS}"
     LDFLAGS="${LDFLAGS} -L${libdir} -L${prefix}/lib"
     LIBS="-ldlrUtilities -ldlrPortability -ldlrCommon"
     AC_TRY_LINK([#include <dlrUtilities/timeUtilities.h>],
         [dlr::utilities::getCurrentTime();],
         [AC_MSG_RESULT([yes])],
         [AC_MSG_ERROR([Unable to build a test program against 
          libdlrUtilities.  Please check that the dlrUtilities utility 
          library is installed.  If it is, and this test still fails, try 
          modifying the LDFLAGS environment variable so that the compiler 
          can more easily find this library.  Please also check that any 
          dependencies are installed, as described in ./README.TXT.  See
          ./config.log for details of the failure.])])
     LIBS="${DLR_SAVED_LIBS}"
     LDFLAGS="$DLR_SAVED_LDFLAGS"
     CPPFLAGS="$DLR_SAVED_CPPFLAGS"])
