/**
***************************************************************************
* @file dlrTest/testMacros.h
* Header file declaring macros for dlrTest library.
*
* Copyright (C) 2004 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
**/

#ifndef _DLR_TESTMACROS_H_
#define _DLR_TESTMACROS_H_

// Anyone who is using these macros will also want to have included
// testException.h .
#include <dlrTest/testException.h>

/**
 ** This macro throws a TestException if its argument does not
 ** evaluate to true.
 **
 ** Example: DLR_TEST_ASSERT(x == 10);
 **/
#define DLR_TEST_ASSERT(assertion) { \
  if(!(assertion)) { \
    DLR_THROW2(dlr::TestException, (#assertion)); \
  } \
}


/**
 ** This macro throws a TestException if its argument does not throw
 ** the specified exception when evaluated.
 **
 ** Example: DLR_TEST_ASSERT_EXCEPTION(ValueException, functionWhichThrows());
 **/
#define DLR_TEST_ASSERT_EXCEPTION(exceptionType, assertion) { \
  try { \
    assertion; \
    DLR_THROW2(dlr::TestException, \
               (#assertion " should throw " #exceptionType)); \
  } catch(const exceptionType&) {} \
}


/** 
 ** This macro makes it easier to call the
 ** TestFixture<>::registerTest() member function.  It only makes
 ** sense to use this macro from within a member function of a
 ** subclass of TestFixture.
 **/
#define DLR_TEST_REGISTER_MEMBER(test) { \
  this->registerTest((#test), &TestFixtureType::test); \
}


#endif // #ifndef _DLR_TESTMACROS_H_
