/**
***************************************************************************
* @file dlrTest/runnableObject.h
*
* Header file declaring RunnableObject class, which is a parent class
* for the TestFuxture class template.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 884 $
* $Date: 2007-05-04 00:49:37 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_RUNNABLEOBJECT_H_
#define _DLR_RUNNABLEOBJECT_H_

#include <dlrTest/autoregister.h>

namespace dlr {

  namespace test {

    /**
     ** This class serves a parent class for the various
     ** TestFuxture<foo> types, allowing virtual function dispatch to
     ** TestFuxture<foo>::run(), and (if DLR_TEST_USE_AUTOMATIC_MAIN
     ** is defined) automatic registration with the pre-written main()
     ** function.  User code will most likely never need to access
     ** this class.
     **/
    class RunnableObject {
    public:
      /** 
       * Constructor registers with the pre-written main() function so
       * that it will be run automatically if the user chooses to link
       * with libdlrTestAutoMain.
       */
      RunnableObject() {registerTestFixture(*this);}

      
      /** 
       * Destructor un-registers with the pre-written main() function
       * so that the no-longer-valid RunnableObject instance won't be
       * invoked automatically if the user chooses to link with
       * libdlrTestAutoMain.
       */
      virtual
      ~RunnableObject() {unregisterTestFixture(*this);}

      
      /** 
       * Pure virtual run() method will dispatch to the run() method
       * of the subclass.
       * 
       * @return The return value should indicate success or failure
       * of the test.
       */
      virtual bool
      run() = 0;
      
    };

  } // namespace test

} // namespace dlr

#endif // #ifdef _DLR_RUNNABLEOBJECT_H_
