/**
***************************************************************************
* @file dlrTest/autoregister.h
*
* Header file allowing control of what gets run by the main() routine
* in libdlrTestAutomaticMain.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 884 $
* $Date: 2007-05-04 00:49:37 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_TEST_AUTOREGISTER_H_
#define _DLR_TEST_AUTOREGISTER_H_

#include <set>

namespace dlr {

  namespace test {

    // Forward declaration.
    class RunnableObject;


    void
    private_registerTestFixture(RunnableObject& testFixture);

    void
    private_unregisterTestFixture(RunnableObject& testFixture);
    
      
#ifndef DLR_TEST_NO_AUTOMATIC_REGISTRATION

    /** 
     * This function Registers a test fixture with the pre-written
     * main() function so that it will be run automatically if the
     * user chooses to link with libdlrTestAutoMain.  This function
     * can be disabled by defining DLR_TEST_NO_AUTOMATIC_REGISTRATION.
     *
     * @param testFixture This argument is the test fixture to be
     * registered.
     */
    inline void
    registerTestFixture(RunnableObject& testFixture) {
      private_registerTestFixture(testFixture);
    }


    /** 
     * This function unregisters a test fixture with the pre-written
     * main() function so that it will not be be run automatically if
     * the user chooses to link with libdlrTestAutoMain.  It undoes
     * the effect of registerTestFixture().  This function can be
     * disabled by defining DLR_TEST_NO_AUTOMATIC_REGISTRATION.
     *
     * @param testFixture This argument is the test fixture to be
     * registered.
     */
    inline void
    unregisterTestFixture(RunnableObject& testFixture) {
      private_unregisterTestFixture(testFixture);
    }

#else /* #ifndef DLR_TEST_NO_AUTOMATIC_REGISTRATION */

    inline void
    registerTestFixture(RunnableObject&) {}

    inline void
    unregisterTestFixture(RunnableObject&) {}
    
#endif /* #ifndef DLR_TEST_NO_AUTOMATIC_REGISTRATION */

  } // namespace test

} // namespace dlr

#endif // #ifdef _DLR_TEST_AUTOREGISTER_H_
