/**
***************************************************************************
* @file dlrRandom/clapack.h
* Klugey header file to declare the LAPACK routines we need.
*
* Copyright (C) 2001-2004 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 857 $
* $Date: 2007-04-06 18:06:25 -0400 (Fri, 06 Apr 2007) $
***************************************************************************
**/


#ifndef _DLR_RANDOM_CLAPACK_H_
#define _DLR_RANDOM_CLAPACK_H_

#include <dlrCommon/types.h>

#ifdef __cplusplus
extern "C" {
#endif
  
  /**
   * This is a declaration for the LAPACK routine dlarnv(), which
   * computes a vector of random real numbers from a uniform
   * distribution.
   */
  void dlarnv_(dlr::Int32* IDIST, dlr::Int32* ISEED, dlr::Int32* N,
               dlr::Float64* X);


#ifdef __cplusplus
}
#endif
#endif /* _DLR_RANDOM_CLAPACK_H_ */
