/**
***************************************************************************
* @file dlrPortability/timeUtilities.h
*
* Header file declaring some useful time-related routines.
*
* (C) Copyright 2004-2006 David LaRose, dlr@alumni.carnegiemellon.edu
* See accompanying LICENSE file for details.
*
* $Revision: 1175 $
* $Date: 2009-07-21 15:35:49 -0400 (Tue, 21 Jul 2009) $
***************************************************************************
**/

#ifndef _DLR_PORTABILITY_TIMEUTILITIES_H_
#define _DLR_PORTABILITY_TIMEUTILITIES_H_

#include <string>

namespace dlr {

  namespace portability {

    enum TimeZone {
      DLR_TZ_GMT,
      DLR_TZ_LOCAL
    };
    
    
    /** 
     * This function returns the current time as a double, the number of
     * seconds since some significant (and OS dependent) event in the
     * distant past.
     * 
     * @return The return value is a double indicating the current time.
     */
    double
    getCurrentTime();


    /** 
     * This function returns the current time as a string in the
     * format "YYYY-MM-DD HH:MM:SS.ss".
     *
     * @param tz This argument 
     * 
     * @return The return value 
     */
    std::string
    getISOTimeString(TimeZone tz = DLR_TZ_LOCAL);

    
    /** 
     * This function causes the program to suspend execution for at
     * least as many seconds as specified by its argument.  The
     * resolution of the timer is implimentation dependent, will
     * always be some small fraction of a second.
     * 
     * @param seconds This argument indicates how many seconds to
     * sleep.
     */
    void
    portableSleep(double seconds);


    /** 
     * This function causes the program to suspend execution for at
     * least as many milliseconds as specified by its argument.  As
     * with portableSleep(), the resolution of the timer is
     * implimentation dependent.
     * 
     * @param seconds This argument indicates how many milliseconds to
     * sleep.
     */
    void
    preciseSleep(int milliseconds);

  } // namespace portability

} // namespace dlr

#endif // #ifndef _DLR_PORTABILITY_TIMEUTILITIES_H_
