/**
***************************************************************************
* @file dlrPortability/standardC.h
*
* Header file declaring routines which conform to various C standards, 
* but are missing from various compilers.
*
* (C) Copyright 2004 David LaRose, dlr@alumni.carnegiemellon.edu
* See accompanying LICENSE file for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
**/

#ifndef _DLR_PORTABILITY_STANDARDC_H_
#define _DLR_PORTABILITY_STANDARDC_H_

#include <cstdio>

#ifdef _WIN32

#ifndef HAVE_SNPRINTF
#define HAVE_SNPRINTF 0
#endif

#else /* #ifdef _WIN32 */

#ifndef HAVE_SNPRINTF
#define HAVE_SNPRINTF 1
#endif

#endif /* #ifdef _WIN32 */

namespace dlr {

  /**
   ** This namespace contains as much of the platform-specific code as
   ** possible, making the other libraries more readable.
   **/
  namespace portability {
    
#if HAVE_SNPRINTF
  using std::snprintf;
#else

  /** 
   * This function is a crippled replacement for std::snprintf.  It is
   * useful on architectures which do not supply a fully featured
   * version.
   * 
   * @param targetString This argument is the buffer into which the
   * formatted string should be written.
   * 
   * @param targetSize This argument Is the size of the target buffer
   * in bytes.
   * 
   * @param format This argument is the format string in normal printf
   * style.
   * 
   * @return The return value is an integer indicating how many bytes
   * were written.
   */
  int snprintf(char* targetString, size_t targetSize, const char* format,
               ...);
  
#endif

  } // namespace portability
  
} // namespace dlr


/* ======= Declarations to maintain compatibility with legacy code. ======= */

namespace dlr {

  using portability::snprintf;

} // namespace dlr

#endif /* #ifndef _DLR_PORTABILITY_STANDARDC_H_ */
