/**
***************************************************************************
* @file dlrNumeric/convolutionStrategy.h
*
* Header file declaring an enum which represents different ways of
* handling border effects when performing convolution and correlation.
*
* Copyright (C) 2006-2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 794 $
* $Date: 2006-10-20 19:00:51 -0400 (Fri, 20 Oct 2006) $
***************************************************************************
**/

#ifndef _DLR_NUMERIC_CONVOLUTIONSTRATEGY_H_
#define _DLR_NUMERIC_CONVOLUTIONSTRATEGY_H_

namespace dlr {

  namespace numeric {
    
    enum ConvolutionStrategy {
      DLR_CONVOLVE_TRUNCATE_RESULT,
      DLR_CONVOLVE_PAD_RESULT,

      /// @deprecated{Please use DLR_CONVOLVE_PAD_RESULT instead.}
      DLR_CONVOLVE_ZERO_PAD_RESULT,
      
      DLR_CONVOLVE_PAD_SIGNAL,
      DLR_CONVOLVE_ZERO_PAD_SIGNAL,
      DLR_CONVOLVE_REFLECT_SIGNAL,
      DLR_CONVOLVE_WRAP_SIGNAL
    };
  

    enum ConvolutionROI {
      DLR_CONVOLVE_ROI_SAME,
      DLR_CONVOLVE_ROI_VALID,
      DLR_CONVOLVE_ROI_FULL
    };
  
  } // namespace numeric

} // namespace dlr


/* ======= Declarations to maintain compatibility with legacy code. ======= */

namespace dlr {

  using numeric::ConvolutionStrategy;
  using numeric::DLR_CONVOLVE_TRUNCATE_RESULT;
  using numeric::DLR_CONVOLVE_ZERO_PAD_RESULT;
  using numeric::DLR_CONVOLVE_ZERO_PAD_SIGNAL;
  using numeric::DLR_CONVOLVE_REFLECT_SIGNAL;
  using numeric::DLR_CONVOLVE_WRAP_SIGNAL;

} // namespace dlr

#endif // #ifndef _DLR_NUMERIC_CONVOLUTIONSTRATEGY_H_
