/**
***************************************************************************
* @file vector2D.cpp
*
* Source file defining Vector2D class.
*
* Copyright (C) 2000-2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 975 $
* $Date: 2007-12-30 01:57:17 -0500 (Sun, 30 Dec 2007) $
***************************************************************************
**/

#include <dlrNumeric/vector2D.h>

namespace dlr {

  namespace numeric {
    
    Vector2D operator+(const Vector2D& vector0, const Vector2D& vector1)
    {
      return Vector2D(vector0.x() + vector1.x(),
                      vector0.y() + vector1.y());
    }
  
    Vector2D operator-(const Vector2D& vector0, const Vector2D& vector1)
    {
      return Vector2D(vector0.x() - vector1.x(),
                      vector0.y() - vector1.y());
    }
  
    Vector2D operator*(const Vector2D& vector0, const Vector2D& vector1)
    {
      return Vector2D(vector0.x() * vector1.x(),
                      vector0.y() * vector1.y());
    }
  
    Vector2D operator/(const Vector2D& vector0, const Vector2D& vector1)
    {
      return Vector2D(vector0.x() / vector1.x(),
                      vector0.y() / vector1.y());
    }
  
    Vector2D operator+(const Vector2D& vector0, double scalar)
    {
      return Vector2D(vector0.x() + scalar,
                      vector0.y() + scalar);
    }

    Vector2D operator-(const Vector2D& vector0, double scalar)
    {
      return Vector2D(vector0.x() - scalar,
                      vector0.y() - scalar);
    }

    Vector2D operator*(const Vector2D& vector0, double scalar)
    {
      return Vector2D(vector0.x() * scalar,
                      vector0.y() * scalar);
    }
    Vector2D operator/(const Vector2D& vector0, double scalar)
    {
      return Vector2D(vector0.x() / scalar,
                      vector0.y() / scalar);
    }

    bool
    operator==(const Vector2D& vector0, const Vector2D& vector1)
    {
      return((vector0.x() == vector1.x()) &&
             (vector0.y() == vector1.y()));
    }

    bool
    operator!=(const Vector2D& vector0, const Vector2D& vector1)
    {
      return(!operator==(vector0, vector1));
    }

    std::ostream&
    operator<<(std::ostream& stream, const Vector2D& vector0)
    {
      stream << "Vector2D(" << vector0.x() << ", " << vector0.y() << ")";
      return stream;
    }

    std::istream&
    operator>>(std::istream& stream, Vector2D& vector0)
    {
      const char intro[] = "Vector2D(";
      const char intermission[] = ",";
      const char outro[] = ")";
      double x, y;
      char inChar;
      size_t index;

      for(index = 0; index < strlen(intro); ++index) {
        inChar = 0;
        stream >> inChar;
        if(inChar != intro[index]) {
          stream.clear(std::ios_base::failbit);
          return stream;
        }
      }
      stream >> x;
      for(index = 0; index < strlen(intermission); ++index) {
        inChar = 0;
        stream >> inChar;
        if(inChar != intermission[index]) {
          stream.clear(std::ios_base::failbit);
          return stream;
        }
      }
      stream >> y;
      for(index = 0; index < strlen(outro); ++index) {
        inChar = 0;
        stream >> inChar;
        if(inChar != outro[index]) {
          stream.clear(std::ios_base::failbit);
          return stream;
        }
      }
      if(stream) {
        vector0.setValue(x, y);
      }
      return stream;
    }

  } // namespace numeric

} // namespace dlr
