/**
***************************************************************************
* @file rotationsTest.cpp
* 
* Source file defining rotationsTest class.
*
* Copyright (C) 2005 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 1001 $
* $Date: 2008-06-11 20:43:38 -0400 (Wed, 11 Jun 2008) $
***************************************************************************
**/

#include <dlrNumeric/rotations.h>

#include <dlrCommon/functional.h>
#include <dlrTest/testFixture.h>

namespace dlr {

  namespace numeric {

    class RotationsTest : public TestFixture<RotationsTest> {

    public:

      RotationsTest();
      ~RotationsTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      void testAxisAngleToQuaternion();
      void testAxisAngleToRollPitchYaw();
      void testAxisAngleToTransform3D();

      void testEulerToTransform3D();
    
      void testQuaternionToAxisAngle();
      void testQuaternionToRollPitchYaw();
      void testQuaternionToTransform3D();

      void testRollPitchYawToAxisAngle();
      void testRollPitchYawToQuaternion();
      void testRollPitchYawToTransform3D();

      void testTransform3DToAxisAngle();
      void testTransform3DToQuaternion();
      void testTransform3DToRollPitchYaw();

    private:

      void assertSimilar(Transform3D const& xf0, Transform3D const& xf1) const;

      double m_defaultTolerance;
    
    }; // class RotationsTest


    /* ============== Member Function Definititions ============== */

    RotationsTest::
    RotationsTest()
      : TestFixture<RotationsTest>("RotationsTest"),
        m_defaultTolerance(1.0E-10)
    {
      // Register all tests.
      DLR_TEST_REGISTER_MEMBER(testAxisAngleToQuaternion);
      DLR_TEST_REGISTER_MEMBER(testAxisAngleToRollPitchYaw);
      DLR_TEST_REGISTER_MEMBER(testAxisAngleToTransform3D);

      DLR_TEST_REGISTER_MEMBER(testEulerToTransform3D);

      DLR_TEST_REGISTER_MEMBER(testQuaternionToAxisAngle);
      DLR_TEST_REGISTER_MEMBER(testQuaternionToRollPitchYaw);
      DLR_TEST_REGISTER_MEMBER(testQuaternionToTransform3D);

      DLR_TEST_REGISTER_MEMBER(testRollPitchYawToAxisAngle);
      DLR_TEST_REGISTER_MEMBER(testRollPitchYawToQuaternion);
      DLR_TEST_REGISTER_MEMBER(testRollPitchYawToTransform3D);

      DLR_TEST_REGISTER_MEMBER(testTransform3DToAxisAngle);
      DLR_TEST_REGISTER_MEMBER(testTransform3DToQuaternion);
      DLR_TEST_REGISTER_MEMBER(testTransform3DToRollPitchYaw);
    }


    void
    RotationsTest::
    testAxisAngleToQuaternion()
    {
    
    }

  
    void
    RotationsTest::
    testAxisAngleToRollPitchYaw()
    {

    }

  
    void
    RotationsTest::
    testAxisAngleToTransform3D()
    {

    }

  
    void
    RotationsTest::
    testEulerToTransform3D()
    {
      // We test by comparison to the (presumably known good)
      // rollPitchYaw routine, and promise to make a more comprehensive
      // test later.
      double angle0 = 0.1;
      double angle1 = 0.2;
      double angle2 = 0.3;
      Axis axis0 = DLR_AXIS_Z;
      Axis axis1 = DLR_AXIS_Y;
      Axis axis2 = DLR_AXIS_X;

      Transform3D xf0 = rollPitchYawToTransform3D(
        Vector3D(angle2, angle1, angle0));
      Transform3D xf1 = eulerToTransform3D(
        angle0, axis0, angle1, axis1, angle2, axis2);
      Transform3D xf2 = (
        eulerToTransform3D(angle2, axis2, 0.0, DLR_AXIS_X, 0.0, DLR_AXIS_X)
        * eulerToTransform3D(angle1, axis1, 0.0, DLR_AXIS_X, 0.0, DLR_AXIS_X)
        * eulerToTransform3D(angle0, axis0, 0.0, DLR_AXIS_X, 0.0, DLR_AXIS_X));
      Transform3D xf3 = (
        eulerToTransform3D(0.0, DLR_AXIS_X, 0.0, DLR_AXIS_X, angle2, axis2)
        * eulerToTransform3D(0.0, DLR_AXIS_X, angle1, axis1, 0.0, DLR_AXIS_X)
        * eulerToTransform3D(angle0, axis0, 0.0, DLR_AXIS_X, 0.0, DLR_AXIS_X));

      this->assertSimilar(xf0, xf1);
      this->assertSimilar(xf0, xf2);
      this->assertSimilar(xf0, xf3);
    }

  
    void
    RotationsTest::
    testQuaternionToAxisAngle()
    {

    }

  
    void
    RotationsTest::
    testQuaternionToRollPitchYaw()
    {

    }

  
    void
    RotationsTest::
    testQuaternionToTransform3D()
    {

    }

  
    void
    RotationsTest::
    testRollPitchYawToAxisAngle()
    {

    }

  
    void
    RotationsTest::
    testRollPitchYawToQuaternion()
    {

    }

  
    void
    RotationsTest::
    testRollPitchYawToTransform3D()
    {

    }

  
    void
    RotationsTest::
    testTransform3DToAxisAngle()
    {

    }

  
    void
    RotationsTest::
    testTransform3DToQuaternion()
    {

    }

  
    void
    RotationsTest::
    testTransform3DToRollPitchYaw()
    {

    }
  

    void
    RotationsTest::
    assertSimilar(Transform3D const& xf0, Transform3D const& xf1) const
    {
      for(size_t ii = 0; ii < 4; ++ii) {
        for(size_t jj = 0; jj < 4; ++jj) {
          DLR_TEST_ASSERT(
            approximatelyEqual(xf0(jj, ii), xf1(jj, ii), m_defaultTolerance));
        }
      }
    }

  } // namespace numeric
  
} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::numeric::RotationsTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::numeric::RotationsTest currentTest;

}

#endif
