dnl
dnl DLR_HAVE_DLRCOMMON()
dnl
dnl Call this autoconf macro to check whether the dlrCommon library
dnl development files are installed on your system.

AC_DEFUN([DLR_HAVE_DLRCOMMON],
    [DLR_SAVED_CPPFLAGS="${CPPFLAGS}"
     CPPFLAGS="${CPPFLAGS} -I${includedir} -I${prefix}/include"
     AC_CHECK_HEADER(dlrCommon/types.h, 
         [],
         [AC_MSG_ERROR([Unable to find dlrCommon/types.h.  Please check that 
              the dlrCommon utility library is installed.  If it is, and this
              test still fails, try modifying the CPPFLAGS environment
              variable so that the compiler can more easily find this
              include file.])])
     AC_MSG_CHECKING([for -ldlrCommon])
     DLR_SAVED_LDFLAGS="${LDFLAGS}"
     DLR_SAVED_LIBS="${LIBS}"
     LDFLAGS="${LDFLAGS} -L${libdir} -L${prefix}/lib"
     LIBS="-ldlrCommon"
     AC_TRY_LINK([#include <dlrCommon/types.h>],
         [dlr::common::Float64 f;],
         [AC_MSG_RESULT([yes])],
         [AC_MSG_ERROR([Unable to build a test program against 
          libdlrCommon.  Please check that the dlrCommon utility 
          library is installed.  If it is, and this test still fails, try 
          modifying the LDFLAGS environment variable so that the compiler 
          can more easily find this library.  Please see ./config.log for 
          details of the failure.])])
     LIBS="${DLR_SAVED_LIBS}"
     LDFLAGS="$DLR_SAVED_LDFLAGS"
     CPPFLAGS="$DLR_SAVED_CPPFLAGS"])
