dnl
dnl DLR_HAVE_DLRNUMERIC()
dnl
dnl Call this autoconf macro to check whether the dlrNumeric library
dnl development files are installed.

AC_DEFUN([DLR_HAVE_DLRNUMERIC],
    [DLR_SAVED_CPPFLAGS="${CPPFLAGS}"
     CPPFLAGS="${CPPFLAGS} -I${includedir} -I${prefix}/include"
     AC_CHECK_HEADER(dlrNumeric/index2D.h, 
         [],
         [AC_MSG_ERROR([Unable to find dlrNumeric/index2D.h.  Please
              check that the dlrNumeric utility library is installed.
              If it is, and this test still fails, try modifying the CPPFLAGS
              environment variable so that the compiler can more easily find
              this include file.])])
     AC_MSG_CHECKING([for -ldlrNumeric])
     DLR_SAVED_LDFLAGS="${LDFLAGS}"
     DLR_SAVED_LIBS="${LIBS}"
     LDFLAGS="${LDFLAGS} -L${libdir} -L${prefix}/lib"
     LIBS="-ldlrNumeric -ldlrCommon"
     AC_TRY_LINK([#include <dlrNumeric/index2D.h>],
         [dlr::numeric::Index2D dummy();],
         [AC_MSG_RESULT([yes])],
         [AC_MSG_ERROR([Unable to build a test program against libdlrNumeric.
          Please check that the dlrNumeric utility library is installed. 
          If it is, and this test still fails, try modifying the LDFLAGS 
          environment variable so that the compiler can more easily find 
          this library.  Please also check that any dependencies are 
          installed, as described in ./README.TXT.  See ./config.log for 
          details of the failure.])])
     LIBS="${DLR_SAVED_LIBS}"
     LDFLAGS="$DLR_SAVED_LDFLAGS"
     CPPFLAGS="$DLR_SAVED_CPPFLAGS"])
