/**
***************************************************************************
* @file dlrUtilities/utilities3D.h
*
* Header file declaring some 3D geometric utilities for finding
* intersects, etc.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 885 $
* $Date: 2007-05-04 01:01:15 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_GEOMETRY_UTILITIES3D_H_
#define _DLR_GEOMETRY_UTILITIES3D_H_

#include <dlrNumeric/vector3D.h>
#include <dlrNumeric/transform3D.h>
#include <dlrGeometry/plane3D.h>
#include <dlrGeometry/ray3D.h>
#include <dlrGeometry/triangle3D.h>


namespace dlr {

  namespace geometry {


    bool
    checkIntersect(const Ray3D& ray, const Triangle3D& triangle);


    bool
    checkIntersect(const Ray3D& ray, const Triangle3D& triangle,
                   numeric::Vector3D& intersect);
    

    bool
    checkIntersect(const Ray3D& ray, const Triangle3D& triangle,
                   double& lambda);

    
    bool
    checkIntersect(const Ray3D& ray, const Triangle3D& triangle,
                   numeric::Vector3D& intersect, double& lambda);

    
    numeric::Vector3D
    findIntersect(const Ray3D& ray, const Plane3D& plane, double& distance);


    numeric::Vector3D
    findIntersect(const Ray3D& ray, const Plane3D& plane);


    numeric::Vector3D
    findIntersect(const Ray3D& ray, const Plane3D& plane, double& distance);


    numeric::Vector3D
    findIntersect(const Ray3D& ray0, const Ray3D& ray1,
                  double& distance0, double& distance1, double& residual);


    Plane3D
    operator*(const numeric::Transform3D& transform,
              const Plane3D& inputPlane);
    

    Ray3D
    operator*(const numeric::Transform3D& transform,
              const Ray3D& inputRay);
    
    
    Triangle3D
    operator*(const numeric::Transform3D& transform,
              const Triangle3D& inputTriangle);
    
  } // namespace utilities
    
} // namespace dlr


/* ======= Inline and template function definitions. ======= */

namespace dlr {

  namespace geometry {

    
  } // namespace geometry
  
} // namespace dlr


#endif /* #ifndef _DLR_GEOMETRY_UTILITIES3D_H_ */
