/**
***************************************************************************
* @file dlrUtilities/utilities2D.h
*
* Header file declaring some 2D geometric utilities for finding
* intersects, etc.
*
* Copyright (C) 2009 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 885 $
* $Date: 2007-05-04 01:01:15 -0400 (Fri, 04 May 2007) $
***************************************************************************
**/

#ifndef _DLR_GEOMETRY_UTILITIES2D_H_
#define _DLR_GEOMETRY_UTILITIES2D_H_

#include <dlrNumeric/transform2D.h>
#include <dlrNumeric/vector2D.h>
#include <dlrGeometry/lineSegment2D.h>
#include <dlrGeometry/ray2D.h>


namespace dlr {

  namespace geometry {

    bool
    checkIntersect(const LineSegment2D& lineSegment0,
                   const LineSegment2D& lineSegment1);


    bool
    checkIntersect(const LineSegment2D& lineSegment0,
                   const LineSegment2D& lineSegment1,
                   numeric::Vector2D& intersect);
    

    bool
    checkIntersect(const Ray2D& ray, const LineSegment2D& lineSegment);


    bool
    checkIntersect(const Ray2D& ray, const LineSegment2D& lineSegment,
                   numeric::Vector2D& intersect);
    

    bool
    checkIntersect(const Ray2D& ray, const LineSegment2D& lineSegment,
                   double& lambda);

    
    bool
    checkIntersect(const Ray2D& ray, const LineSegment2D& lineSegment,
                   numeric::Vector2D& intersect, double& lambda);

    
    numeric::Vector2D
    findClosestPoint(numeric::Vector2D const& point,
                     Ray2D const& ray);

    
    LineSegment2D
    operator*(const numeric::Transform2D& transform,
              const LineSegment2D& inputSegment);
    
    
    Ray2D
    operator*(const numeric::Transform2D& transform,
              const Ray2D& inputRay);
    
    
  } // namespace utilities
    
} // namespace dlr


/* ======= Inline and template function definitions. ======= */

namespace dlr {

  namespace geometry {

    
  } // namespace geometry
  
} // namespace dlr


#endif /* #ifndef _DLR_GEOMETRY_UTILITIES2D_H_ */
