/**
***************************************************************************
* @file triangle3DTest.cpp
*
* Source file defining tests for the Triangle3D class.
*
* Copyright (C) 2007 David LaRose, dlr@cs.cmu.edu
* See accompanying file, LICENSE.TXT, for details.
*
* $Revision: 906 $
* $Date: 2007-05-17 15:04:14 -0400 (Thu, 17 May 2007) $
***************************************************************************
**/

#include <dlrCommon/functional.h>
#include <dlrGeometry/triangle3D.h>
#include <dlrNumeric/utilities.h>
#include <dlrTest/testFixture.h>


namespace dlr {

  namespace geometry {
    
    class Triangle3DTest : public TestFixture<Triangle3DTest> {

    public:

      Triangle3DTest();
      ~Triangle3DTest() {}

      void setUp(const std::string& testName) {}
      void tearDown(const std::string& testName) {}

      // Tests.

    private:

      const double m_defaultTolerance;
      
    }; // class Triangle3DTest


    /* ============== Member Function Definititions ============== */

    Triangle3DTest::
    Triangle3DTest()
      : TestFixture<Triangle3DTest>("Triangle3DTest"),
        m_defaultTolerance(1.0E-12)
    {
      // Empty.
    }

  } // namespace geometry

} // namespace dlr


#if 0

int main(int argc, char** argv)
{
  dlr::geometry::Triangle3DTest currentTest;
  bool result = currentTest.run();
  return (result ? 0 : 1);
}

#else

namespace {

  dlr::geometry::Triangle3DTest currentTest;

}

#endif
